package com.diaoyun.zion.chinafrica.dao;


import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.master.dao.BaseDao;

/**
 * 用户表Dao
 *
 * @author G
 * @date 2019-08-14 09:11:47
 */
public interface TbCfUserInfoDao extends BaseDao<TbCfUserInfoEntity> {

    /**
     * 根据nickname获取用户信息
     * @param nickname
     * @return
     */
    TbCfUserInfoEntity getByNickname(String nickname);

    /**
     * 根据用户名、昵称查找
     * @param account
     * @return
     */
    TbCfUserInfoEntity findByAccount(String account);

    /**
     * 更改用户密码
     * @param userId
     * @param newPassword
     * @param oldPassword
     * @return
     */
    int updatePassWord(String userId, String newPassword, String oldPassword);
}
