package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.constant.KeyConstant;
import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.chinafrica.service.TbCfUserInfoService;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.BaseController;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.base.ResultCode;
import com.diaoyun.zion.master.util.PasswordProvider;
import com.diaoyun.zion.master.validator.Validator;
import com.diaoyun.zion.master.validator.annotation.ValidateParam;
import freemarker.template.TemplateException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URLDecoder;

/**
 * 用户相关api
 *
 * @author G
 */
@Api(tags = "用户相关")
@RestController
@RequestMapping("user")
public class TbCfUserInfoController extends BaseController {

    private static Logger logger = LoggerFactory.getLogger(TbCfUserInfoController.class);

    @Autowired
    private HttpServletRequest request; //自动注入request

    @Autowired
    private TbCfUserInfoService tbCfUserInfoService;

    /**
     * 获取邮箱验证码
     */
    @ApiOperation(value = "获取邮箱验证码")
    @GetMapping(value = "/register/identifyCode/{email}/{nick}")
    @ResponseBody
    public Result getUserIdentifyCode(@ApiParam("用户邮箱") @PathVariable("email") @ValidateParam({Validator.NOT_BLANK}) String email,
                                      @ApiParam("用户昵称 url编码") @PathVariable("nick") @ValidateParam({Validator.NOT_BLANK}) String nick) throws EmailException, TemplateException, IOException {
        nick= URLDecoder.decode(nick,"UTF-8");
        Integer identifyCode = tbCfUserInfoService.sendRegisterIdentifyCode(email, nick);
        request.getSession().setAttribute(KeyConstant.IDENTIFY_CODE, identifyCode);
        // TODO 不能返回验证码，先做测试 identifyCode.toString(),
        Result result=new Result("验证码已发送");
        return result;
    }

    /**
     * 获取存在session中的验证码
     */
    /*@ApiOperation(value = "获取存在session中的验证码")
    @GetMapping(value ="/register/identifyCode/old")
    public String getDeliveryList() {
        String identifyCode= (int) request.getSession().getAttribute(KeyConstant.IDENTIFY_CODE);
        return identifyCode;
    }
    */

    @ApiOperation("修改用户信息")
    @PutMapping()
    @ResponseBody
    public Result updateUserInfo(@ApiParam ("用户信息")@RequestBody TbCfUserInfoVo tbCfUserInfoVo) {
        int res=tbCfUserInfoService.updateUserInfo(tbCfUserInfoVo);
        return new Result(res, "修改成功");
    }

    @ApiOperation("修改用户密码")
    @PutMapping(value="/password/{newPassword}/{oldPassword}")
    @ResponseBody
    public Result updatePassWord(@ApiParam("新密码") @PathVariable @ValidateParam({Validator.NOT_BLANK}) String newPassword
            ,@ApiParam("旧密码") @PathVariable @ValidateParam({Validator.NOT_BLANK}) String oldPassword) {
        Result result =tbCfUserInfoService.updatePassWord(PasswordProvider.encrypt(newPassword),PasswordProvider.encrypt(oldPassword));

        return result;
    }



}
