package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.entity.TbCfOrderEntity;
import com.diaoyun.zion.chinafrica.service.TbCfOrderService;
import com.diaoyun.zion.chinafrica.vo.TbCfOrderVo;
import com.diaoyun.zion.master.base.Result;
import com.github.pagehelper.PageInfo;
import com.stripe.exception.StripeException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;

/**
 * Controller
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Api(tags = "订单")
@Controller
@RequestMapping("order")
public class TbCfOrderController {
    @Autowired
    private TbCfOrderService tbCfOrderService;

    @ApiOperation("用户结算，返回订单")
    @GetMapping("/settle")
    @ResponseBody
    public Result<TbCfOrderVo> settleAccount() throws IOException, URISyntaxException {
        Result result = tbCfOrderService.settleAccount();
        return result;
    }

    @ApiOperation("用户确定下单")
    @PostMapping("/place")
    @ResponseBody
    public Result placeOrder(@ApiParam("订单详情") @RequestBody TbCfOrderVo tbCfOrderVo) throws IOException, URISyntaxException {
        Result result = tbCfOrderService.placeOrder(tbCfOrderVo);
        return result;
    }

    @ApiOperation("获取用户订单 默认10条")
    @GetMapping
    @ResponseBody
    /**
     * pageNum 页数
     * pageSize 每页大小
     */
    public Result<PageInfo> getUserOrderList(@ApiParam(value = "页数") @RequestParam(required = false) Integer pageNum,
                                             @ApiParam(value ="每页大小") @RequestParam(required = false) Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        Result result = tbCfOrderService.getUserOrderList(pageNum, pageSize);
        return result;
    }

    @ApiOperation("获取stripe公钥")
    @GetMapping("/stripe")
    @ResponseBody
    public Result<String> getStripePublicKey() {
        Result result = tbCfOrderService.getStripePublicKey();
        return result;
    }

    @ApiOperation("发起订单支付")
    @PostMapping("/pay/{orderId}/{token}")
    @ResponseBody
    public Result payForOrder(@ApiParam("订单id")@PathVariable("orderId")String orderId,@ApiParam("支付token")@PathVariable("token")String token) {
        Result result = tbCfOrderService.payForOrder(orderId,token);
        return result;
    }


    /*
    @ApiOperation("取消订单")
    @DeleteMapping
    @ResponseBody
    public Result cancelOrder*/

}
