package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.entity.TbCfCategoryHsEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfExpressTemplateEntity;
import com.diaoyun.zion.chinafrica.service.TbCfExpressTemplateService;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/**
 * 运费模板Controller
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
//@Api(tags = "运费模板")
@Controller
@RequestMapping("expressTemplate")
public class TbCfExpressTemplateController {
    @Autowired
    private TbCfExpressTemplateService tbCfExpressTemplateService;


    /**
     * 查看所有运费模板
     */
    @ApiOperation("查看所有运费模板")
    @RequestMapping("/queryAll")
    @ResponseBody
    public Result queryAll() {
        Map<String, Object> params=null;
        List<TbCfExpressTemplateEntity> list = tbCfExpressTemplateService.queryList(params);

        return new Result().setData(list);
    }


}
