package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.constant.KeyConstant;
import com.diaoyun.zion.chinafrica.entity.TbCfCouponEntity;
import com.diaoyun.zion.chinafrica.service.TbCfCouponService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.common.RedisCache;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 优惠券表Controller
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Api(tags = "优惠券")
@Controller
@RequestMapping("coupon")
public class TbCfCouponController {
    @Autowired
    private TbCfCouponService tbCfCouponService;

    @ApiOperation("领取优惠券")
    @GetMapping("/{couponId}")
    @ResponseBody
    public Result<TbCfCouponEntity> takeCoupon(@ApiParam("优惠券")@PathVariable("couponId")String couponId) {
        Result result= tbCfCouponService.takeCoupon(couponId);
        return result;
    }



}
