package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.TbCfAddressService;
import com.diaoyun.zion.chinafrica.vo.TbCfAddressVo;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.validator.Validator;
import com.diaoyun.zion.master.validator.annotation.ValidateParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * 地址相关api
 *
 * @author G
 */
@Api(tags = "地址相关")
@RestController
@RequestMapping("/address")
public class TbCfAddressController {
    @Autowired
    private TbCfAddressService tbCfAddressService;

    @ApiOperation("获取用户所有地址")
    @GetMapping
    @ResponseBody
    public Result<List<TbCfAddressVo>> getUserInfoList() {
        List<TbCfAddressVo> TbCfAddressVoList=tbCfAddressService.getUserInfoList();
        return new Result(TbCfAddressVoList);
    }









    @ApiOperation("增加用户地址信息")
    @PostMapping
    @ResponseBody
    public Result addUserInfo(@ApiParam("地址信息") @RequestBody TbCfAddressVo tbCfAddressVo) {
        tbCfAddressVo=tbCfAddressService.saveAddress(tbCfAddressVo);
        return new Result(tbCfAddressVo,"新增成功");
    }

    @ApiOperation("修改用户地址信息")
    @PutMapping(value="/{addressId}")
    @ResponseBody
    public Result updateUserInfo(@ApiParam("地址id") @PathVariable("addressId")String addressId, @ApiParam("地址信息") @RequestBody TbCfAddressVo tbCfAddressVo) {
        tbCfAddressVo.setAddressId(addressId);
        tbCfAddressVo=tbCfAddressService.updateAddress(tbCfAddressVo);
        return new Result(tbCfAddressVo,"修改成功");
    }

    @ApiOperation("删除用户地址信息")
    @DeleteMapping(value="/{addressId}")
    @ResponseBody
    public Result deleteUserInfo(@ApiParam("地址id") @PathVariable("addressId")String addressId) {
        int res=tbCfAddressService.delete(addressId);
        return new Result(res,"删除成功");
    }

    @ApiOperation("设置为默认地址")
    @PutMapping(value="/default/{addressId}")
    @ResponseBody
    public Result configDefaultAddress(@ApiParam("地址id") @PathVariable("addressId")String addressId) {
        int res=tbCfAddressService.configDefaultAddress(addressId);
        return new Result(res,"设置成功");
    }
}
