package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.SpiderService;
import com.diaoyun.zion.chinafrica.vo.DetailParamVo;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ExecutionException;

/**
 * 爬取网络相关数据Controller
 *
 * @author G
 * @date 2019-08-22 15:51:16
 */
@Api(tags = "数据爬虫")
@Controller
@RequestMapping("/spider")
public class SpiderController {

    @Autowired
    private SpiderService spiderService;

    @ApiOperation("获取商品详情")
    @GetMapping("/item/detail")
    @ResponseBody
    public Result getItemDetail(@ApiParam @RequestBody DetailParamVo detailParamVo) throws InterruptedException, ExecutionException, URISyntaxException, IOException {
        Map<String,Object> itemMap=spiderService.getItemDetail(detailParamVo.getTargetUrl());
        Result result=new Result(itemMap,"商品规格信息");
        return result;
    }


}
