package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.client.SessionUser;
import com.diaoyun.zion.chinafrica.client.SessionUtils;
import com.diaoyun.zion.chinafrica.client.SsoFilter;
import com.diaoyun.zion.chinafrica.constant.KeyConstant;
import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.chinafrica.service.TbCfUserInfoService;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.BaseController;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.base.ResultCode;
import com.diaoyun.zion.master.base.StateConstant;
import com.diaoyun.zion.master.common.TokenManager;
import com.diaoyun.zion.master.enums.UserTypeEnum;
import com.diaoyun.zion.master.util.CookieUtils;
import com.diaoyun.zion.master.util.IdUtil;
import com.diaoyun.zion.master.util.PasswordProvider;
import com.diaoyun.zion.master.validator.Validator;
import com.diaoyun.zion.master.validator.annotation.ValidateParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/**
 * 用户登录
 *
 * @author G
 */
@Api(tags = "用户登录")
@RestController
@RequestMapping("/login")
public class LoginController extends BaseController {

    private static Logger logger = LoggerFactory.getLogger(LoginController.class);
    // 登录页 TODO 改为配置
    private static final String LOGIN_PATH = "page/login.html";

    @Resource(name = "redisTokenManager")
    private TokenManager tokenManager;

    @Autowired
    private HttpServletRequest request; //自动注入request

    @Autowired
    private HttpServletResponse response;

    @Autowired
    private TbCfUserInfoService tbCfUserInfoService;


    @ApiOperation(value = "注册并登录")
    @PostMapping(value = "/register")
    @ResponseBody
    public Result<TbCfUserInfoVo> registerAndLogin(@ApiParam("用户信息") @RequestBody TbCfUserInfoVo tbCfUserInfoVo) {
        Result result = tbCfUserInfoService.registerAndLogin(tbCfUserInfoVo);
        return result;
    }

    /*@ApiOperation("登录页")
    @RequestMapping(method = RequestMethod.GET)
    public void login(
            @ApiParam(value = "返回链接", required = true) @ValidateParam({ Validator.NOT_BLANK }) String backUrl,
            HttpServletRequest request) throws IOException {
        String token = CookieUtils.getCookie(request, TokenManager.TOKEN);
        if (StringUtils.isNotBlank(token) && tokenManager.validate(token) != null) {
            response.sendRedirect(authBackUrl(backUrl, token));
            //return "redirect:" + authBackUrl(backUrl, token);
        }
        else {
            response.sendRedirect(goLoginPath(backUrl, request));
            //return goLoginPath(backUrl, request);
        }
    }
*/
    @ApiOperation("登录")
    @PostMapping
    @ResponseBody
    public Result<TbCfUserInfoVo> login(@ApiParam(value = "登录名") @RequestParam(required = false) String account,
                        @ApiParam(value = "密码") @RequestParam(required = false) String password) {
        Result result = tbCfUserInfoService.login(getIpAddr(request), account,password);
        return result;
    }


    /*@ApiOperation(value = "登录")
    @GetMapping("/form")
    @ResponseBody
    public Result login(@ApiParam(value = "登录名") @RequestParam(required = false) String account,
                        @ApiParam(value = "密码") @RequestParam(required = false) String password) {
        Result result;
        String token = CookieUtils.getCookie(request, TokenManager.TOKEN);
        if (StringUtils.isNotBlank(token)) {// 有cookies的情况
            TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
            if (tbCfUserInfoVo == null) {
                CookieUtils.removeCookie(response, TokenManager.TOKEN, "/", null);
                result = new Result().setCode(ResultCode.ERROR).setMessage("请重新登录");
            } else {
                result = tbCfUserInfoService.login(getIpAddr(request), tbCfUserInfoVo.getAccount(), tbCfUserInfoVo.getPassword());
                SessionUtils.setSessionUser(request, new SessionUser(token, tbCfUserInfoVo.getAccount()));
            }

        } else {
            Validator.NOT_BLANK.validate("登录名", account);
            Validator.NOT_BLANK.validate("密码", password);
            result = tbCfUserInfoService.login(getIpAddr(request), account, PasswordProvider.encrypt(password));

        }
        return result;
    }
*/
    @ApiOperation("第三方登录")
    @PostMapping("/thirdParty")
    @ResponseBody
    public Result<TbCfUserInfoVo>  loginByThirdParty(@ApiParam("第三方账号") @RequestParam(required = false) String amount,
                                    @ApiParam("用户昵称 url编码") @RequestParam(required = false) String nick,
                                    @ApiParam("账号类型") @RequestParam(required = false) String userType) throws UnsupportedEncodingException {
        Result result=tbCfUserInfoService.loginByThirdParty(getIpAddr(request),amount,nick,userType);
        return result;
    }


    /*private String authBackUrl(String backUrl, String token) {
        StringBuilder sbf = new StringBuilder(backUrl);
        if (backUrl.indexOf("?") > 0) {
            sbf.append("&");
        } else {
            sbf.append("?");
        }
        sbf.append(SsoFilter.SSO_TOKEN_NAME).append("=").append(token);
        return sbf.toString();
    }

    private String goLoginPath(String backUrl, HttpServletRequest request) {
        request.setAttribute("backUrl", backUrl);
        return LOGIN_PATH;
    }*/
}
