package com.diaoyun.zion.chinafrica.client;

import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.base.ResultCode;
import com.diaoyun.zion.master.common.TokenManager;
import com.diaoyun.zion.master.exception.ValidateException;
import com.diaoyun.zion.master.util.CookieUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * 验证请求用户是否已经登录
 *
 * @author G
 */
@Component
@Aspect
public class TokenVerification {
    @Autowired
    private HttpServletRequest request;
    @Resource(name="redisTokenManager")
    private TokenManager tokenManager;

    //验证是否登录
    //@Pointcut("!execution(* com.diaoyun.zion.chinafrica.controller.LoginController*.*(..))&&within(com.diaoyun.zion.chinafrica.controller.*)")
    @Pointcut("within(com.diaoyun.zion.chinafrica.controller.*)" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.SpiderController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.LoginController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfUserInfoController.getUserIdentifyCode(..))")
    public void controllerAspect() {

    }

    //通知：在所拦截方法的前后执行一段逻辑
    @Around("controllerAspect()")
    public Object validateLogin(ProceedingJoinPoint pjp) throws Throwable {
        Result result;
        String token = CookieUtils.getCookie(request, TokenManager.TOKEN);
        //不需要登录
        if (StringUtils.isNotBlank(token) && tokenManager.validate(token) != null) {
            return  pjp.proceed();
            //return "redirect:" + authBackUrl(backUrl, token);
        }
        else {
            result=new Result("请先登录").setCode(ResultCode.NEED_LOGIN);
        }
        return result;

    }
}
