package com.diaoyun.zion.chinafrica.api;

import com.alibaba.druid.support.json.JSONUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 提供给第三方api
 * 
 * @author G
 *
 */
@Api(tags = "提供给第三方api")
@RestController
@RequestMapping("/chinafrica/api")
public class ThirdPartyController {

	private static Logger logger= LoggerFactory.getLogger(ThirdPartyController.class);
    /**
     *获取某段时间的下单数据
     */
    @ApiOperation(value = "获取某段时间的下单数据")
    @GetMapping(value ="/order")
    public String getOrderList(@RequestParam("beginTime")String beginTime,@RequestParam("endTime")String endTime) {
        List<Map<String,Object>> returnList=new ArrayList<>();
        Map<String,Object> map=new HashMap<>();
        map.put("orderId","orderId8848");
        map.put("userId","userId2019");
        map.put("dealTime","订单成交时间时间戳1564558584");
        returnList.add(map);
        return JSONUtils.toJSONString(returnList);
    }

    /**
     *获取某段时间已发货订单数据
     */
    @ApiOperation(value = "获取某段时间已发货订单数据")
    @GetMapping(value ="/delivery")
    public String getDeliveryList(@RequestParam("beginTime")String beginTime,@RequestParam("endTime")String endTime) {
        List<Map<String,Object>> returnList=new ArrayList<>();
        Map<String,Object> map=new HashMap<>();
        map.put("orderId","orderId8848");
        map.put("userId","userId2019");
        map.put("deliveryAddress","收货人地址");
        map.put("deliveryTime","发货时间戳1564558584");
        map.put("itemType","货物类别Id");
        map.put("expressId","快递单号");
        returnList.add(map);
        returnList.add(map);
        return JSONUtils.toJSONString(returnList);
    }

    /**
     *根据订单号获取详细订单数据
     */
    @ApiOperation(value = "获取某段时间已发货订单数据")
    @GetMapping(value ="/order/detail/{orderId}")
    public String getOrderDetailById(@PathVariable("orderId")String orderId) {
        Map<String,Object> map=new HashMap<>();
        map.put("orderId","订单Id8848");
        map.put("deliveryName","收货人");
        map.put("deliveryPhone","收货人手机");
        map.put("deliveryAddress","收货人地址");
        List<Map<String,Object>> itemList=new ArrayList<>();
        Map<String,Object> itemMap=new HashMap<>();
        itemMap.put("itemCategory","品名");
        itemMap.put("itemPrice","单价");
        itemMap.put("itemNum","数量");
        Map<String,Object> itemMap2=new HashMap<>();
        itemMap2.put("itemCategory","品名2");
        itemMap2.put("itemPrice","单价2");
        itemMap2.put("itemNum","数量2");
        itemList.add(itemMap);
        itemList.add(itemMap2);
        map.put("itemList",itemList);
        return JSONUtils.toJSONString(map);
    }




}
