$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfstationsales/list',
        colModel: [
			{label: 'saleId', name: 'saleId', index: 'sale_id', key: true, hidden: true},
			{label: '站点id', name: 'stationId', index: 'station_id', width: 80},
			{label: '商品id', name: 'itemId', index: 'item_id', width: 80},
			{label: '站点类型', name: 'stationType', index: 'station_type', width: 80},
			{label: '商品价格', name: 'itemPrice', index: 'item_price', width: 80},
			{label: '商品数量', name: 'itemNum', index: 'item_num', width: 80},
			{label: '支付流水号', name: 'payId', index: 'pay_id', width: 80},
			{label: '支付方式', name: 'payWayCode', index: 'pay_way_code', width: 80},
			{label: '支付时间', name: 'payTime', index: 'pay_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfStationSales: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfStationSales = {};
		},
		update: function (event) {
            let saleId = getSelectedRow("#jqGrid");
			if (saleId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(saleId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfStationSales.saleId == null ? "../tbcfstationsales/save" : "../tbcfstationsales/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfStationSales),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let saleIds = getSelectedRows("#jqGrid");
			if (saleIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfstationsales/delete",
                    params: JSON.stringify(saleIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(saleId){
            Ajax.request({
                url: "../tbcfstationsales/info/"+saleId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfStationSales = r.tbCfStationSales;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});