$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfitemorderr/list',
        colModel: [
			{label: 'orderItemId', name: 'orderItemId', index: 'order_item_id', key: true, hidden: true},
			{label: '商品表记录id', name: 'itemId', index: 'item_id', width: 80},
			{label: '订单id', name: 'orderId', index: 'order_id', width: 80},
			{label: '是否有效', name: 'enableFlag', index: 'enable_flag', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfItemOrderR: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfItemOrderR = {};
		},
		update: function (event) {
            let orderItemId = getSelectedRow("#jqGrid");
			if (orderItemId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(orderItemId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfItemOrderR.orderItemId == null ? "../tbcfitemorderr/save" : "../tbcfitemorderr/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfItemOrderR),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let orderItemIds = getSelectedRows("#jqGrid");
			if (orderItemIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfitemorderr/delete",
                    params: JSON.stringify(orderItemIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(orderItemId){
            Ajax.request({
                url: "../tbcfitemorderr/info/"+orderItemId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfItemOrderR = r.tbCfItemOrderR;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});