$(function () {
    $("#jqGrid").Grid({
        url: '../tbcffinance/list',
        colModel: [
			{label: 'finaceId', name: 'finaceId', index: 'finace_id', key: true, hidden: true},
			{label: '订单id', name: 'orderId', index: 'order_id', width: 80},
			{label: '用户id', name: 'userId', index: 'user_id', width: 80},
			{label: '支付款项', name: 'payAccount', index: 'pay_account', width: 80},
			{label: '支付流水号', name: 'payId', index: 'pay_id', width: 80},
			{label: '支付方式', name: 'payWayCode', index: 'pay_way_code', width: 80},
			{label: '支付时间', name: 'payTime', index: 'pay_Time', width: 80},
			{label: '支付后显示页面', name: 'receiptUrl', index: 'receipt_url', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfFinance: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},

	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfFinance = {};
		},
		update: function (event) {
            let finaceId = getSelectedRow("#jqGrid");
			if (finaceId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(finaceId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfFinance.finaceId == null ? "../tbcffinance/save" : "../tbcffinance/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfFinance),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
			
            let finaceIds = getSelectedRows("#jqGrid");
			if (finaceIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcffinance/delete",
                    params: JSON.stringify(finaceIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(finaceId){
            Ajax.request({
                url: "../tbcffinance/info/"+finaceId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfFinance = r.tbCfFinance;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        },
		a(){
            console.log('bcs')
            $.get('../tbcffinance/findByAvgOrderPrice',function (res) {
                console.log(res)
            })
            // Ajax.request({
            //     url: "../tbcffinance/findBySumPay",
            //     type: "GET",
            //     contentType: "application/json",
            //     successCallback: function () {
			//
            //         alert('操作成功', function (index) {
            //             vm.reload();
            //         });
            //     }
            // });
		}
	},
	mounted(){

	}


});