$(function () {
    $("#jqGrid").Grid({
        url: '../tbcffeedbackrecord/list',
        colModel: [
			{label: 'recordId', name: 'recordId', index: 'record_id', key: true, hidden: true},
			{label: '反馈用户id', name: 'userId', index: 'user_id', width: 80},
			{label: '反馈问题id', name: 'feedbackId', index: 'feedback_id', width: 80},
			{label: '反馈填写内容', name: 'answer', index: 'answer', width: 80},
			{label: '创建时间', name: 'createTime', index: 'create_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfFeedbackRecord: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfFeedbackRecord = {};
		},
		update: function (event) {
            let recordId = getSelectedRow("#jqGrid");
			if (recordId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(recordId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfFeedbackRecord.recordId == null ? "../tbcffeedbackrecord/save" : "../tbcffeedbackrecord/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfFeedbackRecord),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let recordIds = getSelectedRows("#jqGrid");
			if (recordIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcffeedbackrecord/delete",
                    params: JSON.stringify(recordIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(recordId){
            Ajax.request({
                url: "../tbcffeedbackrecord/info/"+recordId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfFeedbackRecord = r.tbCfFeedbackRecord;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});