package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfVersionDao;
import com.diaoyun.zion.chinafrica.entity.TbCfVersionEntity;
import com.diaoyun.zion.chinafrica.service.TbCfVersionService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Service实现类
 *
 * @author lipengjun
 * @date 2019-10-22 14:33:29
 */
@Service("tbCfVersionService")
public class TbCfVersionServiceImpl implements TbCfVersionService {
    @Autowired
    private TbCfVersionDao tbCfVersionDao;

    @Override
    public TbCfVersionEntity queryObject(String versionId) {
        return tbCfVersionDao.queryObject(versionId);
    }

    @Override
    public List<TbCfVersionEntity> queryList(Map<String, Object> map) {
        return tbCfVersionDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfVersionDao.queryTotal(map);
    }

    @Override
    public int save(TbCfVersionEntity tbCfVersion) {
        tbCfVersion.setVersionId(IdUtil.createIdbyUUID());
        return tbCfVersionDao.save(tbCfVersion);
    }

    @Override
    public int update(TbCfVersionEntity tbCfVersion) {
        return tbCfVersionDao.update(tbCfVersion);
    }

    @Override
    public int delete(String versionId) {
        return tbCfVersionDao.delete(versionId);
    }

    @Override
    public int deleteBatch(String[] versionIds) {
        return tbCfVersionDao.deleteBatch(versionIds);
    }

    @Override
    public TbCfVersionEntity getVersionCode(String code) {
        return tbCfVersionDao.getVersionCode(code);
    }
}
