package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfItemOrderRDao;
import com.diaoyun.zion.chinafrica.entity.TbCfItemOrderREntity;
import com.diaoyun.zion.chinafrica.service.TbCfItemOrderRService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 订单商品对应表Service实现类
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Service("tbCfItemOrderRService")
public class TbCfItemOrderRServiceImpl implements TbCfItemOrderRService {
    @Autowired
    private TbCfItemOrderRDao tbCfItemOrderRDao;

    @Override
    public TbCfItemOrderREntity queryObject(String orderItemId) {
        return tbCfItemOrderRDao.queryObject(orderItemId);
    }

    @Override
    public List<TbCfItemOrderREntity> queryList(Map<String, Object> map) {
        return tbCfItemOrderRDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfItemOrderRDao.queryTotal(map);
    }

    @Override
    public int save(TbCfItemOrderREntity tbCfItemOrderR) {
        tbCfItemOrderR.setOrderItemId(IdUtil.createIdbyUUID());
        return tbCfItemOrderRDao.save(tbCfItemOrderR);
    }

    @Override
    public int update(TbCfItemOrderREntity tbCfItemOrderR) {
        return tbCfItemOrderRDao.update(tbCfItemOrderR);
    }

    @Override
    public int delete(String orderItemId) {
        return tbCfItemOrderRDao.delete(orderItemId);
    }

    @Override
    public int deleteBatch(String[] orderItemIds) {
        return tbCfItemOrderRDao.deleteBatch(orderItemIds);
    }
}
