package com.diaoyun.zion.chinafrica.service.impl;


import com.diaoyun.zion.chinafrica.dao.TbCfItemCommentDao;
import com.diaoyun.zion.chinafrica.entity.TbCfItemCommentEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfItemCommentEntityExtends;
import com.diaoyun.zion.chinafrica.service.TbCfItemCommentService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.IdUtil;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * Service实现类
 *
 * @author lipengjun
 * @date 2019-11-18 14:31:39
 */
@Service("tbCfItemCommentService")
public class TbCfItemCommentServiceImpl implements TbCfItemCommentService {
    private static Logger logger = LoggerFactory.getLogger(TbCfItemCommentServiceImpl.class);
    @Autowired
    private TbCfItemCommentDao tbCfItemCommentDao;

    @Override
    public TbCfItemCommentEntity queryObject(String id) {
        return tbCfItemCommentDao.queryObject(id);
    }

    @Override
    public List<TbCfItemCommentEntity> queryList(Map<String, Object> map) {
        return tbCfItemCommentDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfItemCommentDao.queryTotal(map);
    }

    @Override
    public int save(TbCfItemCommentEntity tbCfItemComment) {
        tbCfItemComment.setId(IdUtil.createIdbyUUID());
        return tbCfItemCommentDao.save(tbCfItemComment);
    }

    @Override
    public int update(TbCfItemCommentEntity tbCfItemComment) {
        return tbCfItemCommentDao.update(tbCfItemComment);
    }

    @Override
    public int delete(String id) {
        return tbCfItemCommentDao.delete(id);
    }

    @Override
    public int deleteBatch(String[] ids) {
        return tbCfItemCommentDao.deleteBatch(ids);
    }

    /**
     * 查询商品最新一条评论
     *
     * @param itemId
     * @return
     */
    @Override
    public Result queryLastComment(String itemId) {
        Result result = new Result();
        try {
            TbCfItemCommentEntityExtends lastComment = tbCfItemCommentDao.queryLastComment(itemId);
            if (lastComment != null) {
                result.setData(lastComment).setMessage("success");
                logger.info("query comment success,the itemId is:" + itemId);
            } else {
                result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage("comment is null");
                logger.error("comment is null,the itemId is:" + itemId);
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }

    /**
     * 查询更多评论
     *
     * @param itemId
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    public Result querycomments(String itemId, Integer pageNum, Integer pageSize) {
        Result<PageInfo> result = new Result();
        try {
            startPage(pageNum, pageSize);
            List<TbCfItemCommentEntity> comments = tbCfItemCommentDao.querycomments(itemId);
            PageInfo<TbCfItemCommentEntity> pageInfo = new PageInfo<>(comments);
            result.setData(pageInfo);
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }

    /**
     * 商品评价
     *
     * @param comment
     * @return
     */
    public Result addComment(TbCfItemCommentEntity comment) {
        Result result = new Result();
        try {
            comment.setId(IdUtil.createIdbyUUID());
            comment.setDelFlag(0);
            comment.setLikeNum(0L);
            comment.setCreateTime(new Date());
            comment.setUpdateTime(new Date());
            int i = tbCfItemCommentDao.save(comment);
            if (i > 0) {
                result.setCode(ResultCodeEnum.SUCCESS.getCode()).setMessage("Comment on success!");
            } else {
                result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage("Comment on failure!");
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }

    /**
     * 删除商品评论
     *
     * @param commentId
     * @return
     */
    @Override
    public Result delComment(String commentId) {
        Result result = new Result();
        try {
            TbCfItemCommentEntity comment = tbCfItemCommentDao.queryObject(commentId);
            comment.setDelFlag(1);
            comment.setUpdateTime(new Date());
            int i = tbCfItemCommentDao.update(comment);
            if (i > 0) {
                result.setCode(ResultCodeEnum.SUCCESS.getCode()).setMessage("Deleted successfully!");
            } else {
                result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage("Deletion failed!");
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }


}
