package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfVersionEntity;


import java.util.List;
import java.util.Map;

/**
 * Service接口
 *
 * @author lipengjun
 * @date 2019-10-22 14:33:29
 */
public interface TbCfVersionService {

    /**
     * 根据主键查询实体
     *
     * @param id 主键
     * @return 实体
     */
    TbCfVersionEntity queryObject(String versionId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfVersionEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfVersion 实体
     * @return 保存条数
     */
    int save(TbCfVersionEntity tbCfVersion);

    /**
     * 根据主键更新实体
     *
     * @param tbCfVersion 实体
     * @return 更新条数
     */
    int update(TbCfVersionEntity tbCfVersion);

    /**
     * 根据主键删除
     *
     * @param versionId
     * @return 删除条数
     */
    int delete(String versionId);

    /**
     * 根据主键批量删除
     *
     * @param versionIds
     * @return 删除条数
     */
    int deleteBatch(String[] versionIds);

    TbCfVersionEntity getVersionCode(String code);
}
