package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfCouponIssueEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;

import java.util.List;
import java.util.Map;

/**
 * 优惠券发放表Service接口
 *
 * @author lipengjun
 * @date 2019-10-21 12:11:53
 */
public interface TbCfCouponIssueService {

    /**
     * 根据主键查询实体
     *
     * @param
     * @return 实体
     */
    TbCfCouponIssueEntity queryObject(String couponIssueId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfCouponIssueEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfCouponIssue 实体
     * @return 保存条数
     */
    int save(TbCfCouponIssueEntity tbCfCouponIssue);

    /**
     * 根据主键更新实体
     *
     * @param tbCfCouponIssue 实体
     * @return 更新条数
     */
    int update(TbCfCouponIssueEntity tbCfCouponIssue);


    /**
     * 根据主键删除
     *
     * @param couponIssueId
     * @return 删除条数
     */
    int delete(String couponIssueId);

    /**
     * 根据主键批量删除
     *
     * @param couponIssueIds
     * @return 删除条数
     */
    int deleteBatch(String[] couponIssueIds);

    /**
     * 获取用户列表
     * @param status
     * @return
     */
    List<TbCfUserInfoEntity> queryByUserStatus(Integer status);

    /**
     * 获取用户状态
     * @param couponIssueId
     * @return
     */
    int queryByStatus(String couponIssueId);

}
