package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.entity.TbCfItemCommentEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfReplyEntity;
import com.diaoyun.zion.chinafrica.service.ShopifyService;
import com.diaoyun.zion.chinafrica.service.TbCfItemCommentService;
import com.diaoyun.zion.chinafrica.service.TbCfReplyService;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Auther: wudepeng
 * @Date: 2019/11/15
 * @Description: 调用shopify API，获取商品信息;查看商品评价、回复
 */
@Api(tags = "获取shopify的商品信息")
@RestController
@RequestMapping("/shopify")
public class ShopifyController {

    @Autowired
    private ShopifyService shopifyService;
    @Autowired
    private TbCfItemCommentService tbCfItemCommentService;
    @Autowired
    private TbCfReplyService tbCfReplyService;

    /**
     * 查询商品
     *
     * @return
     */
    @ApiOperation(value = "查询商品")
    @GetMapping("/queryproducts")
    public Result queryShopifyProducts() {

        return shopifyService.queryShopifyProducts();
    }


    /**
     * 查询分类商品
     *
     * @param product_type
     * @param page_info
     * @return
     */
    @ApiOperation(value = "查询分类商品")
    @GetMapping("/queryproductsbytype")
    public Result queryProductsByType(@ApiParam("商品分类") @RequestParam(value = "product_type", required = false) String product_type,
                                      @ApiParam("商品ID") @RequestParam(value = "page_info", required = false) String page_info
    ) {

        return shopifyService.queryProductsByType(product_type, page_info);
    }


    /**
     * 查看商品详情
     *
     * @param product_id 商品ID
     * @return
     */
    @ApiOperation(value = "查看商品详情")
    @GetMapping("/queryproductdetails")
    public Result queryProductsDetails(@ApiParam("商品ID") @RequestParam("product_id") String product_id) {

        return shopifyService.queryProductsDetails(product_id);
    }

    /**
     * 查询所有商品
     *
     * @param product_id 商品ID
     * @return
     */
    @ApiOperation(value = "查询所有商品")
    @GetMapping("/queryallproducts")
    public Result queryAllProducts(@ApiParam("商品ID") @RequestParam(value = "product_id", required = false) String product_id) {

        return shopifyService.queryAllProducts(product_id);
    }

    /**
     * 查询商品最新一条评论
     *
     * @param itemId 商品ID
     * @return
     */
    @ApiOperation(value = "查询商品评论")
    @GetMapping("/querylastcomment")
    public Result queryLastComment(@ApiParam("商品ID") @RequestParam("itemId") String itemId) {

        return tbCfItemCommentService.queryLastComment(itemId);
    }

    /**
     * 查看商品的更多评论
     *
     * @param itemId
     * @param pageNum
     * @param pageSize
     * @return
     */
    @ApiOperation(value = "查看更多评论")
    @GetMapping("/querycomments")
    public Result queryComments(@ApiParam("商品ID") @RequestParam("itemId") String itemId,
                                @ApiParam(value = "页数 默认1") @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                @ApiParam(value = "每页大小 默认10") @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {
        return tbCfItemCommentService.querycomments(itemId, pageNum, pageSize);
    }

    /**
     * 查看回复信息
     *
     * @param commentId
     * @param pageNum
     * @param pageSize
     * @return
     */
    @ApiOperation(value = "查看回复信息")
    @GetMapping("/queryreplys")
    public Result queryReplys(@ApiParam("评论ID") @RequestParam("commentId") String commentId,
                              @ApiParam(value = "页数 默认1") @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                              @ApiParam(value = "每页大小 默认10") @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {
        return tbCfReplyService.queryReplys(commentId, pageNum, pageSize);
    }


    /**
     * 商品评价
     *
     * @param comment
     * @return
     */
    @ApiOperation(value = "商品评价")
    @PostMapping("/addcomment")
    public Result addComment(@ApiParam("评论") @RequestBody TbCfItemCommentEntity comment) {
        return tbCfItemCommentService.addComment(comment);
    }

    /**
     * 删除评论
     *
     * @param commentId
     * @return
     */
    @DeleteMapping(value = "/delcomment")
    public Result delComment(@ApiParam("评论ID") @RequestParam("commentId") String commentId) {
        return tbCfItemCommentService.delComment(commentId);
    }

    /**
     * 回复消息
     *
     * @param reply
     * @return
     */
    @ApiOperation(value = "回复消息")
    @PostMapping("/addreply")
    public Result addReply(@ApiParam("回复消息") @RequestBody TbCfReplyEntity reply) {

        return tbCfReplyService.addReply(reply);
    }

    /**
     * 删除回复
     *
     * @param replyId
     * @return
     */
    @ApiOperation("删除回复")
    @DeleteMapping("/delreply")
    public Result delReply(@ApiParam("回复ID") @RequestParam("replyId") String replyId) {
        return tbCfReplyService.delReply(replyId);
    }

    /**
     * 通过商品标题搜索
     *
     * @param title
     * @return
     */
    @ApiOperation("搜索商品")
    @GetMapping("/search")
    public Result searchProducts(@ApiParam("商品标题") @RequestParam("title") String title) {
        return shopifyService.searchProductByTitle(title);
    }
}
