package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.FlutterWaveService;
import com.diaoyun.zion.chinafrica.vo.FlutterWaveCard;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * @Auther: wudepeng
 * @Date: 2019/11/08
 * @Description: FlutterWave支付
 */
@RestController
@RequestMapping("/flutterwave")
public class FlutterWaveController {
    @Autowired
    private FlutterWaveService flutterWaveService;

    /**
     * 发起支付
     *
     * @param orderId         订单ID
     * @param flutterWaveCard 账号信息
     * @return
     */
    @PostMapping("/pay")
    public Result payForOrderByCard(@ApiParam("订单ID") @RequestParam("orderId") String orderId, @RequestBody FlutterWaveCard flutterWaveCard) {
        return flutterWaveService.payForOrder(orderId, flutterWaveCard);
    }

    /**
     * 验证付款
     *
     * @param
     * @param orderId
     * @return
     */
    @PostMapping("/verifyPay")
    public Result verifyPay(@ApiParam("订单ID") @RequestParam("orderId") String orderId) {

        return flutterWaveService.verifyPay(orderId);
    }


    /**
     * 退款
     *
     * @param flutterWaveCard
     * @return
     */
    @PostMapping("/refund")
    public Result refund(@RequestBody FlutterWaveCard flutterWaveCard) {
        return flutterWaveService.refund(flutterWaveCard);
    }

    /**
     * 支付参数
     *
     * @param userId
     * @return
     */
    @GetMapping("/queryParams")
    public Result queryParams(@ApiParam("用户ID") @RequestParam("userId") String userId) {
        return flutterWaveService.queryParams(userId);
    }
}
