package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.SpiderUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

import static com.diaoyun.zion.master.util.SpiderUtil.exchangeRate;

/**
 * COACH(蔻驰)
 *
 * @author 爱酱油不爱醋
 */
@Component("coachSpider")
public class CoachSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * Coach 数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String[] urlSpilt = targetUrl.split("/");
        String[] pIdSpilt = urlSpilt[4].split(".html");
        String pId = pIdSpilt[0];
        targetUrl = "https://" + urlSpilt[2] + "/rest/default/V1/applet/product/CONF" + pId;
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.COACH.getValue());
        JSONObject resultObj = JSONObject.fromObject(content);
        ProductResponse productResponse = formatProductResponse(resultObj, pId);
        resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     * @param dataMap 主要的Json数据
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(JSONObject dataMap, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(true);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        // 取 data 节点对象
        JSONObject dataObj = dataMap.getJSONObject("data");
        // 如果获取的长度为空，哪说明没有在商品的详情页内，返回空参数
        if (dataObj.size() == 0) {
            return productResponse;
        }

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        itemInfo.setShopName("Coach");
        itemInfo.setShopUrl("https://china.coach.com");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(dataObj.getString("name"));
        //////////////////////////////////// 获取商品基本信息(图片下取)End /////////////////////////

        List<String> sizeNoList = new ArrayList<>();
        List<String> colorNoList = new ArrayList<>();
        // 取 attributes 节点数组
        JSONArray attributesArr = dataObj.getJSONArray("attributes");

        for (int i = 0; i < attributesArr.size(); i++) {
            ///////////////////////// 获取商品颜色属性 ////////////////////////////////////////////////////////////////
            // 0 位为颜色属性
            if (i == 0) {
                JSONArray valuesArr = attributesArr.getJSONObject(i).getJSONArray("values");
                for (int j = 0; j < valuesArr.size(); j++) {
                    JSONObject valuesObj = valuesArr.getJSONObject(j);

                    String colorNo = valuesObj.getString("value_index");
                    String color = valuesObj.getString("label");
                    String imageUrl = valuesObj.getString("image");
                    if (i == 0) {
                        itemInfo.setPic(imageUrl);
                    }

                    colorNoList.add(colorNo);

                    ProductProp productPropColor = new ProductProp();
                    productPropColor.setPropId(colorNo);
                    productPropColor.setPropName(color);
                    productPropColor.setImage(imageUrl);
                    propSet.add(productPropColor);
                    if (productPropSet.get("颜色") == null) {
                        productPropSet.put("颜色", propSet);
                    } else {
                        Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                        propSet.addAll(oldPropSet);
                        productPropSet.put("颜色", propSet);
                    }
                }
                ///////////////////////// 获取商品颜色属性End ////////////////////////////////////////////////////////////////


                // 1 位为尺寸属性(有的商品不一定会存在，如手提包)
            } else if (i == 1) {
                // 取 values 节点数组
                JSONArray valuesArr = attributesArr.getJSONObject(i).getJSONArray("values");

                ///////////////////////// 获取商品尺码属性 ////////////////////////////////////////////////////////////////
                for (int j = 0; j < valuesArr.size(); j++) {
                    JSONObject valuesObj = valuesArr.getJSONObject(j);

                    String sizeNo = valuesObj.getString("value_index");
                    String size = valuesObj.getString("label");

                    sizeNoList.add(sizeNo);

                    ProductProp productPropSize = new ProductProp();
                    productPropSize.setPropId(sizeNo);
                    productPropSize.setPropName(size);
                    sizePropSet.add(productPropSize);
                    if (productPropSet.get("尺码") == null) {
                        productPropSet.put("尺码", sizePropSet);
                    } else {
                        Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                        sizePropSet.addAll(oldPropSet);
                        productPropSet.put("尺码", sizePropSet);
                    }
                    ///////////////////////// 获取商品尺码属性 END/////////////////////////////////////////////////////
                }
            }

        }

        for (String colorNo : colorNoList) {
            for (String sizeNo : sizeNoList) {
                // 设置 skuStr
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSkuStr(skuStr);
                productSkuStock.setSellableQuantity(999);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                // 获取商品的原始价(存在优惠价格)
                String fullPrice = dataObj.getString("price");
                fullPrice = SpiderUtil.retainNumber(fullPrice);
                // TODO 转换汇率，目前商品单位是人民币
                fullPrice = exchangeRate(fullPrice);

                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setPrice(fullPrice);
                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);
                //////////////////////////////////// 获取原始价 END //////////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("Coach");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}