package com.diaoyun.zion;


import com.alibaba.fastjson.JSON;
import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.chinafrica.service.TbCfUserInfoService;
import com.diaoyun.zion.chinafrica.vo.Products;
import com.diaoyun.zion.chinafrica.vo.ShopifyConstant;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.ListUtil;
import com.github.pagehelper.PageInfo;
import com.google.gson.JsonArray;
import com.mashape.unirest.http.Headers;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.SmsApi;
import com.yunpian.sdk.api.TplApi;
import com.yunpian.sdk.api.YunpianApi;
import com.yunpian.sdk.constant.YunpianConstant;
import com.yunpian.sdk.model.SmsBatchSend;
import com.yunpian.sdk.model.SmsSingleSend;
import io.swagger.models.auth.In;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpRequest;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import springfox.documentation.spring.web.json.Json;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.*;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * 微信
 *
 * @author egan
 * @email egzosn@gmail.com
 * @date 2017/8/18
 */
public class PayTest {

    @Test
    public void test() throws IOException {
        Map<String, Object> params = new HashMap<>();
        params.put("fields", "product_type");
        String connection = HttpClientUtil.createConnection(ShopifyConstant.productTypeUrl(), params, "UTF-8");
        List list = new ArrayList();
        JSONArray products = JSONObject.fromObject(connection).getJSONArray("products");
        for (int i = 0; i < products.size(); i++) {
            String string = products.getString(i);
            JSONObject jsonObject = JSONObject.fromObject(string);
            String product_type = jsonObject.getString("product_type");
            if (!"".equals(product_type) && !list.contains(product_type)) {
                list.add(product_type);
            }
        }
    }

    @Test
    public void test1() throws IOException {
        Result result = new Result();
        Map<String, Object> params = new HashMap<>();
        params.put("product_type", "Christmas");
        params.put("limit", "1");
        //params.put("since_id", "4248995594337");
        List list = new ArrayList<>();

        String data = HttpClientUtil.createConnection(ShopifyConstant.productTypeUrl(), params, "UTF-8");
        JSONArray products = JSONObject.fromObject(data).getJSONArray("products");
        for (int i = 0; i < products.size(); i++) {
            Products product = JSON.parseObject(data, Products.class);
        }
    }

    @Test
    public void test3() {
        Integer count = 0;
        while (count < 4) {
            count++;
        }
    }


    public static List<String> pageBySubList(List list, int pagesize, int currentPage) {
        int totalcount = list.size();
        int pagecount = 0;
        List<String> subList;
        int m = totalcount % pagesize;
        if (m > 0) {
            pagecount = totalcount / pagesize + 1;
        } else {
            pagecount = totalcount / pagesize;
        }
        if (m == 0) {
            subList = list.subList((currentPage - 1) * pagesize, pagesize * (currentPage));
        } else {
            if (currentPage == pagecount) {
                subList = list.subList((currentPage - 1) * pagesize, totalcount);
            } else {
                subList = list.subList((currentPage - 1) * pagesize, pagesize * (currentPage));
            }
        }
        return subList;
    }

    @Test
    public void url() throws MalformedURLException, URISyntaxException, UnsupportedEncodingException {
        String url = "http://www.oschina.net/search?scope=bbs&q=C%E8%AF%AD%E8%A8%80";
        String targetUrl = URLDecoder.decode(url, "utf-8");
        Map<String, String> paramMap = HttpClientUtil.getParamMap(targetUrl);
        String q = URLDecoder.decode(paramMap.get("q"), "utf-8");
    }


    @Test
    public void testHeaders() throws UnirestException {
//        String url = "https://7f0e048ac4016b9357bb1eb2217e4201:1c97a1222c5b40e0597c816c6dfecac0@mollykitty.myshopify.com/admin/api/2019-10/products.json";
//        Map<String, Object> map = new HashMap<>();
//        map.put("product_type", "Men");
//        map.put("limit", "10");
//        String data = HttpClientUtil.getConnection(url, map,"utf-8");
//        System.out.println(data);

        HttpResponse<String> response = Unirest.get("https://7f0e048ac4016b9357bb1eb2217e4201:1c97a1222c5b40e0597c816c6dfecac0@mollykitty.myshopify.com/admin/api/2019-10/products.json?limit=10&page_info=eyJwcm9kdWN0X3R5cGUiOiJNZW4iLCJsYXN0X2lkIjo0Mjg2ODYxMTgxMDI1LCJsYXN0X3ZhbHVlIjoiQmxhY2sgc25lYWtlcnMiLCJkaXJlY3Rpb24iOiJuZXh0In0")
                .headers(new HashMap<>())
                .asString();

        List<String> link = response.getHeaders().get("Link");
        String str = link.get(0);
        String[] split = str.split(",");
        String s = split[0];
    }

    /**
     * 批量发送
     *
     * @throws UnsupportedEncodingException
     */
    @Test
    public void sendMessage() throws UnsupportedEncodingException {
//        YunpianClient clnt = new YunpianClient("cb20310db0e7dcc76a827afbd2ba548f").init();
//        Map<String, String> param = clnt.newParam(5);
//        //param.put("tpl_id","3253208");
//        param.put(YunpianConstant.MOBILE, "+260977598876");
        String code = RandomStringUtils.randomNumeric(6);
//        param.put(YunpianConstant.TEXT, "【Afrishop】you are logging in for verification, and the verification code is '" + code + "'.Do not disclose the verification code to others.");
//        // param.put(EXTEND, "001");
//        // param.put(UID, "10001");
//        // param.put(CALLBACK_URL, "http://yourreceiveurl_address");
//        com.yunpian.sdk.model.Result<SmsBatchSend> result = clnt.sms().batch_send(param);
//        System.out.println(result);
        String text = "【Afrishop】you are logging in for verification, and the verification code is '" + code + "'.Do not disclose the verification code to others.";
        sendMessageByText("13751400455", text);
    }

    public void sendMessageByText(String phone, String text) {
        YunpianClient clnt = new YunpianClient("cb20310db0e7dcc76a827afbd2ba548f").init();
        Map<String, String> param = clnt.newParam(5);
        param.put(YunpianConstant.MOBILE, phone);
        String code = RandomStringUtils.randomNumeric(6);
        param.put(YunpianConstant.TEXT, text);
        com.yunpian.sdk.model.Result<SmsBatchSend> result = clnt.sms().batch_send(param);
    }


    @Test
    public void sendTpl() {
//        YunpianClient clnt = new YunpianClient("cb20310db0e7dcc76a827afbd2ba548f").init();
//        Map<String, String> param = clnt.newParam(5);
//        param.put(YunpianConstant.MOBILE, "13751400455");
//        param.put(YunpianConstant.TPL_ID, "3253208");
//        param.put(YunpianConstant.TPL_VALUE, "#code#=" + code);

        String code = RandomStringUtils.randomNumeric(6);
        sendMessageByTpl("cb20310db0e7dcc76a827afbd2ba548f", "13751400455", "3253208", "#code#=" + code);
    }

    /**
     * 通过模板群发
     *
     * @param apiKey
     * @param phone
     * @param tplId
     * @param tplVal
     */
    public void sendMessageByTpl(String apiKey, String phone, String tplId, String tplVal) {
        YunpianClient clnt = new YunpianClient(apiKey).init();
        Map<String, String> param = clnt.newParam(5);
        param.put(YunpianConstant.MOBILE, phone);
        param.put(YunpianConstant.TPL_ID, tplId);
        String code = RandomStringUtils.randomNumeric(6);
        param.put(YunpianConstant.TPL_VALUE, tplVal);
        // param.put(EXTEND, "001");
        // param.put(UID, "10001");
        com.yunpian.sdk.model.Result<SmsBatchSend> r = clnt.sms().tpl_batch_send(param);
    }

    @Test
    public void testList() {
        boolean flag = false;
        List<Integer> list = new ArrayList<>();
        list.add(20);
        list.add(40);
        if (!list.contains("20")) {
            flag = true;
        }
    }

    @Test
    public void testBigdecimal(){
        BigDecimal b=new BigDecimal("0");
    }

    @Test
    public void test01(){
        String hour="00:00:0-1";
        System.out.println(hour.contains("-1"));
        if (hour.contains("-1")) {
            hour.substring(0,7);
            hour=hour+"0";
        }
        System.out.println(hour);
    }
}
