$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfhomepage/list',
        colModel: [
			{label: 'pageId', name: 'pageId', index: 'page_id', key: true, hidden: true},
			{label: '图片名称', name: 'imgName', index: 'img_name', width: 80},
			{label: '排序(倒序显示)', name: 'sort', index: 'sort', width: 80},
			{label: '跳转链接', name: 'linkUrl', index: 'link_url', width: 100,formatter:linkFormat},
			{label: '图片', name: 'imgUrl', index: 'img_url', width: 80,formatter: imageFormat},
			{label: '是否支持浏览', name: 'scanFlag', index: 'scan_flag', width: 80,formatter: yesOrNoFormat},
			{label: '是否跳转', name: 'redirectFlag', index: 'redirect_flag', width: 80,formatter: yesOrNoFormat},
			{label: '是否可用', name: 'enableFlag', index: 'enable_flag', width: 80,formatter: yesOrNoFormat}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfHomePage: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfHomePage = {};
		},
		update: function (event) {
            let pageId = getSelectedRow("#jqGrid");
			if (pageId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(pageId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfHomePage.pageId == null ? "../tbcfhomepage/save" : "../tbcfhomepage/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfHomePage),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let pageIds = getSelectedRows("#jqGrid");
			if (pageIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfhomepage/delete",
                    params: JSON.stringify(pageIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(pageId){
            Ajax.request({
                url: "../tbcfhomepage/info/"+pageId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfHomePage = r.tbCfHomePage;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        },
		tirggerFile : function (event) {
			var file = event.target.files[0]; // (利用console.log输出看file文件对象)
			var formData = new FormData();
			formData.append("file",file);
			$.ajax({
				url: "../api/upload/image/",
				type: "POST",
				data:formData,
				cache:false,         //不设置缓存
				processData: false,  // 不处理数据
				contentType: false,// 不设置内容类型
				success: function (result) {
					result=JSON.parse(result);
					//console.log(result)
					if (result.errno == 0) {//成功
						vm.tbCfHomePage.imgUrl=result.data;
						vm.$forceUpdate();
					} else {
						iview.Message.error(result.errmsg);
					}
				}
			});
		}
	}
});