package com.diaoyun.zion.master.quartz;

import com.diaoyun.zion.chinafrica.service.TbCfExchangeService;
import com.diaoyun.zion.chinafrica.service.TbCfExpCatRelService;
import com.diaoyun.zion.chinafrica.service.TbCfUserInfoService;
import com.diaoyun.zion.master.util.HttpClientUtil;
import freemarker.template.TemplateException;
import org.apache.commons.mail.EmailException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.List;


@Component
public class QuartzMethod {
    @Autowired
    private TbCfUserInfoService tbCfUserInfoService;

    @Autowired
    private TbCfExchangeService tbCfExchangeService;

    //@Scheduled(cron = "0 0/1 * * * ? ")
    public  void sendEmail() throws EmailException, TemplateException, IOException {
        System.out.println("////////////////////////////////////////////////////");
      String email= tbCfUserInfoService.findEmails();
      //  String email= "1203063316@qq.com";
        if(email!=null){
            String s = tbCfUserInfoService.sendRegister(email);
            if(s!=null){
                System.out.println("已发送邮件:"+email);
            }
        }
    }

    /**
     * 美元-克瓦查
     * @throws IOException
     * @throws URISyntaxException
     */
    @Scheduled(cron = "0 0/2 * * * ? ")
    public void  getRent() throws IOException, URISyntaxException {
        String content = HttpClientUtil.getContentByUrl("https://cn.valutafx.com/USD-ZMW.htm?amount=1", "rent");
        // 解析为 Document 对象
        Document document = Jsoup.parse(content);
        String rent = document.select("div[class=rate-value]").text();
        BigDecimal rate=new BigDecimal(rent);
        System.err.println(rate);
        String type="USD-ZMW";
        tbCfExchangeService.updateByType(type,rate);
    }

    /**
     * 美元-人民币
     * @throws IOException
     * @throws URISyntaxException
     */
    @Scheduled(cron = "0 0/2 * * * ? ")
    public void  getRate() throws IOException, URISyntaxException {
        String content = HttpClientUtil.getContentByUrl("https://cn.valutafx.com/USD-CNY.htm?amount=1", "rent");
        // 解析为 Document 对象
        Document document = Jsoup.parse(content);
        String rent = document.select("div[class=rate-value]").text();
        BigDecimal rate=new BigDecimal(rent);
        System.err.println(rate);
        String type="USD-CNY";
        tbCfExchangeService.updateByType(type,rate);
    }
}
