package com.diaoyun.zion.master.exception;


import com.diaoyun.zion.master.enums.ResultCodeEnum;

/**
 * 业务逻辑异常
 * 
 * @author Joe
 */
public class ServiceException extends ApplicationException{

	private static final long serialVersionUID = -2678203134198782909L;
	
	public static final String MESSAGE = "业务逻辑异常";
	
	public ServiceException() {
		super(MESSAGE);
	}

	public ServiceException(String message) {
		super(message);
		this.code = ResultCodeEnum.SERVICE_ERROR.getCode();
	}
	
	public ServiceException(int code, String message) {
		super(message);
		this.code = code;
	}

	public ServiceException(String message, Throwable cause) {
		super(message, cause);
		this.code = ResultCodeEnum.SERVICE_ERROR.getCode();
	}
	
	public ServiceException(int code, String message, Throwable cause) {
		super(message, cause);
		this.code = code;
	}

	public ServiceException(Throwable cause) {
		super(cause);
		this.code = ResultCodeEnum.SERVICE_ERROR.getCode();
	}
}
