package com.diaoyun.zion.chinafrica.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 购物车商品详情实体
 * 表名 tb_cf_item_detail
 *
 * @author G
 * @date 2019-08-16 15:51:16
 */
@ApiModel
public class TbCfCartItemDetailVo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 记录id
     */
    @ApiModelProperty("订单记录id")
    private String ordersId;
    /**
     * 购物车记录id
     */
    @ApiModelProperty("购物车记录id")
    private String cartRecordId;
    /**
     * 是否已经被勾选，0未勾选，1勾选
     */
    @ApiModelProperty("是否已经被勾选，0未勾选，1勾选")
    private Integer checkFlag;
    /**
     * 商品表记录id
     */
    @ApiModelProperty("商品表记录id")
    private String itemId;
    /**
     * 商品链接
     */
    @ApiModelProperty("商品链接")
    private String sourceItemId;
    /**
     * 来源站点id
     */
    @ApiModelProperty("来源站点id")
    private String stationId;
    /**
     * 站点类型
     */
    @ApiModelProperty("站点类型")
    private Integer stationType;
    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemTitle;
    /**
     * 商品数量
     */
    @ApiModelProperty("商品数量")
    private Integer itemNum;
    /**
     * 商品主图
     */
    @ApiModelProperty("商品主图")
    private String itemImg;
    /**
     * 商品价格
     */
    @ApiModelProperty("商品价格")
    private BigDecimal itemPrice;
    /**
     * 商品分类
     */
    @ApiModelProperty("商品分类")
    private String itemCategory;
    /**
     * 商品skus
     */
    @ApiModelProperty("商品skus")
    private String itemSku;
    /**
     * 所属店铺id
     */
    @ApiModelProperty("所属店铺id")
    private String shopId;
    /**
     * 所属商铺名
     */
    @ApiModelProperty("所属商铺名")
    private String shopName;
    /**
     * 所属商铺链接
     */
    @ApiModelProperty("所属商铺链接")
    private String shopUrl;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("商品品名")
    private String descripitionName;


    @ApiModelProperty("订单商品状态")
    private Integer orderStatus;

    @ApiModelProperty("评论状态")
    private boolean isCommented;

    public boolean isCommented() {
        return isCommented;
    }

    public void setCommented(boolean commented) {
        isCommented = commented;
    }

    public String getOrdersId() {
        return ordersId;
    }

    public void setOrdersId(String ordersId) {
        this.ordersId = ordersId;
    }

    public String getDescripitionName() {
        return descripitionName;
    }

    public void setDescripitionName(String descripitionName) {
        this.descripitionName = descripitionName;
    }

    /**
     * 设置：商品id
     */
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    /**
     * 获取：商品id
     */
    public String getItemId() {
        return itemId;
    }

    /**
     * 设置：来源站点id
     */
    public void setStationId(String stationId) {
        this.stationId = stationId;
    }

    /**
     * 获取：来源站点id
     */
    public String getStationId() {
        return stationId;
    }

    /**
     * 设置：站点类型
     */
    public void setStationType(Integer stationType) {
        this.stationType = stationType;
    }

    /**
     * 获取：站点类型
     */
    public Integer getStationType() {
        return stationType;
    }

    /**
     * 设置：商品名称
     */
    public void setItemTitle(String itemTitle) {
        this.itemTitle = itemTitle;
    }

    /**
     * 获取：商品名称
     */
    public String getItemTitle() {
        return itemTitle;
    }

    /**
     * 设置：商品数量
     */
    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    /**
     * 获取：商品数量
     */
    public Integer getItemNum() {
        return itemNum;
    }

    /**
     * 设置：商品主图
     */
    public void setItemImg(String itemImg) {
        this.itemImg = itemImg;
    }

    /**
     * 获取：商品主图
     */
    public String getItemImg() {
        return itemImg;
    }

    /**
     * 设置：商品价格
     */
    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    /**
     * 获取：商品价格
     */
    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    /**
     * 设置：商品分类
     */
    public void setItemCategory(String itemCategory) {
        this.itemCategory = itemCategory;
    }

    /**
     * 获取：商品分类
     */
    public String getItemCategory() {
        return itemCategory;
    }

    /**
     * 设置：商品skus
     */
    public void setItemSku(String itemSku) {
        this.itemSku = itemSku;
    }

    /**
     * 获取：商品skus
     */
    public String getItemSku() {
        return itemSku;
    }

    /**
     * 设置：所属商铺名
     */
    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    /**
     * 获取：所属商铺名
     */
    public String getShopName() {
        return shopName;
    }

    /**
     * 设置：所属商铺链接
     */
    public void setShopUrl(String shopUrl) {
        this.shopUrl = shopUrl;
    }

    /**
     * 获取：所属商铺链接
     */
    public String getShopUrl() {
        return shopUrl;
    }

    public String getSourceItemId() {
        return sourceItemId;
    }

    public void setSourceItemId(String sourceItemId) {
        this.sourceItemId = sourceItemId;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCartRecordId() {
        return cartRecordId;
    }

    public void setCartRecordId(String cartRecordId) {
        this.cartRecordId = cartRecordId;
    }

    public Integer getCheckFlag() {
        return checkFlag;
    }

    public void setCheckFlag(Integer checkFlag) {
        this.checkFlag = checkFlag;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }
}
