package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.constant.KeyConstant;
import com.diaoyun.zion.chinafrica.dao.*;
import com.diaoyun.zion.chinafrica.entity.*;
import com.diaoyun.zion.chinafrica.service.TbCfStationItemService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.common.RedisCache;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.IdUtil;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import net.bytebuddy.asm.Advice;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * 站点商品Service实现类
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Service("tbCfStationItemService")
public class TbCfStationItemServiceImpl implements TbCfStationItemService {
    @Autowired
    private TbCfStationItemDao tbCfStationItemDao;
    @Autowired
    private TbCfItemDescDao tbCfItemDescDao;

    @Autowired
    private TbCfGoodstypeDao tbCfGoodstypeDao;

    @Autowired
    private TbCfItemSkusDao tbCfItemSkusDao;

    @Autowired
    private TbCfItemCollectionDao tbCfItemCollectionDao;

    @Autowired
    private TbCfCategoryDao tbCfCategoryDao;

    @Autowired
    private TbCfOptionDao tbCfOptionDao;
    @Resource
    private RedisCache<Object> redisCache;

    @Autowired
    private TbCfItemCommentDao tbCfItemCommentDao;

    @Override
    public TbCfStationItemEntity queryObject(String itemId) {
        return tbCfStationItemDao.queryObject(itemId);
    }

    @Override
    public List<TbCfStationItemEntity> getGoodsTypeList(String categoryId) {
        return tbCfStationItemDao.getGoodsTypeList(categoryId);
    }

    @Override
    public List<TbCfStationItemEntity> queryList(Map<String, Object> map) {
        return tbCfStationItemDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfStationItemDao.queryTotal(map);
    }

    @Override
    public int save(TbCfStationItemEntity tbCfStationItem) {
        tbCfStationItem.setItemId(IdUtil.createIdbyUUID());
        return tbCfStationItemDao.save(tbCfStationItem);
    }

    @Override
    public int update(TbCfStationItemEntity tbCfStationItem) {
        return tbCfStationItemDao.update(tbCfStationItem);
    }

    @Override
    public int delete(String itemId) {
        return tbCfStationItemDao.delete(itemId);
    }

    @Override
    public int deleteBatch(String[] itemIds) {
        return tbCfStationItemDao.deleteBatch(itemIds);
    }

    @Override
    public Result getItemStationList(Integer pageNum, Integer pageSize, String categoryId) {
        Result<PageInfo> result = new Result<>();
        startPage(pageNum, pageSize);
        List<TbCfStationItemEntity> tbCfStationItemList = tbCfStationItemDao.getItemStationList(categoryId);
        PageInfo<TbCfStationItemEntity> pageInfo = new PageInfo<>(tbCfStationItemList);
        result.setData(pageInfo);
        return result;
    }

    /**
     * 首页商品
     *
     * @return
     */
    @Override
    public Result queryPageHomeItems() {
        Result result = new Result();
        Map<String, Object> map = new HashMap();
        List<PageHomeItems> pageHomeItemsList = new ArrayList<>();
        try {
            List<TbCfGoodstypeEntity> categoryList = tbCfGoodstypeDao.queryList(null);
            for (TbCfGoodstypeEntity category : categoryList) {
                PageHomeItems pageHomeItems = new PageHomeItems();
                pageHomeItems.setCategoryId(category.getGoodstypeId());
                pageHomeItems.setCategoryName(category.getGoodstypeTitle());
                List<TbCfStationItemEntity> itemList = tbCfStationItemDao.getGoodsTypeList(category.getGoodstypeId());
                pageHomeItems.setItemInfo(itemList);
                pageHomeItemsList.add(pageHomeItems);
            }
            map.put("items", pageHomeItemsList);
            result.setData(map).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
        }

        return result;
    }


    /**
     * 商品sku、详情
     *
     * @param itemId
     * @return
     */
    @Override
    public Result queryItemSku(String itemId, String userId) {
        Result result = new Result();
        Map<String, Object> map = new HashMap<>();
        boolean collection = false;
        try {
            //判断商品是否被收藏
            if (!StringUtils.isBlank(userId)) {
                TbCfItemCollectionEntity isCollection = tbCfItemCollectionDao.queryIsCollection(userId, itemId);
                if (isCollection != null) {
                    collection = true;
                }
            }
            //商品信息
            TbCfStationItemEntity itemInfo = tbCfStationItemDao.queryObject(itemId);
            //商品规格
            List<TbCfCategoryEntity> categoryList = tbCfCategoryDao.queryByItemId(itemId);
            List<ItemOption> itemOptionList = new ArrayList<>();
            for (int i = 0; i < categoryList.size(); i++) {
                ItemOption itemOption = new ItemOption();
                itemOption.setCategoryId(categoryList.get(i).getCategoryId());
                itemOption.setCategoryName(categoryList.get(i).getCategoryName());
                List<TbCfOptionEntity> optionList = tbCfOptionDao.queryByCid(categoryList.get(i).getCategoryId());
                itemOption.setOptionList(optionList);
                itemOptionList.add(itemOption);
            }
            //商品评论
            List<TbCfItemCommentEntity> itemCommentList = tbCfItemCommentDao.queryScore(itemId);
            double totalScore = 0;
            double score = 5;
            double total = 0;
            if (itemCommentList != null && itemCommentList.size() > 0) {
                for (int i = 0; i < itemCommentList.size(); i++) {
                    total = itemCommentList.get(i).getItemScore() + itemCommentList.get(i).getLogisticsScore() + itemCommentList.get(i).getServiceScore() + itemCommentList.get(i).getPriceScore();
                    totalScore += total;
                }
                int num = 4 * itemCommentList.size();
                BigDecimal to = new BigDecimal(totalScore);
                BigDecimal count = new BigDecimal(num);
                score = to.divide(count, 1, BigDecimal.ROUND_UP).doubleValue();
            }

            //商品sku
            List<BigDecimal> priceList = new ArrayList<>();
            List<TbCfItemSkusEntity> itemSkuList = tbCfItemSkusDao.querySkusByItemId(itemId);
            List<ItemSkuInfo> skuInfoList = new ArrayList<>();
            for (TbCfItemSkusEntity itemSkusEntity : itemSkuList) {
                ItemSkuInfo skuInfo = new ItemSkuInfo();
                skuInfo.setId(itemSkusEntity.getId());
                skuInfo.setItemId(itemSkusEntity.getItemId());
                skuInfo.setPrice(itemSkusEntity.getSkuPrice());
                skuInfo.setCount(itemSkusEntity.getSkuCount());
                String[] name = itemSkusEntity.getSkuName().split("/");
                String[] desc = itemSkusEntity.getSkuDesc().split("/");
                List<SkuDetail> list = new ArrayList<>();
                for (int i = 0; i < name.length; i++) {
                    SkuDetail skuDetail = new SkuDetail();
                    skuDetail.setSkuName(name[i]);
                    skuDetail.setSkuDesc(desc[i]);
                    list.add(skuDetail);
                }
                skuInfo.setSkus(list);
                skuInfoList.add(skuInfo);
                BigDecimal skuPrice = itemSkusEntity.getSkuPrice();
                priceList.add(skuPrice);
            }
            Collections.sort(priceList);
            //价格范围
            String priceRange = priceList.get(0).toString() + "-" + priceList.get(priceList.size() - 1);
            //商品详情
            TbCfItemDescEntity itemDesc = tbCfItemDescDao.queryObject(itemId);
            map.put("isCollection", collection);
            map.put("itemInfo", itemInfo);
            map.put("itemDesc", itemDesc);
            map.put("itemDetail", skuInfoList);
            // map.put("categoryList", categoryList);
            map.put("score", score);
            map.put("optionList", itemOptionList);
            // map.put("priceRange", priceRange);
            result.setData(map).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 商品搜索
     *
     * @param name
     * @return
     */
    @Override
    public Result searchItems(String name, String order) {
        Result result = new Result();
        try {
            List<TbCfStationItemEntity> itemList = tbCfStationItemDao.searchItems(name.trim(), order);
            result.setData(itemList).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 查询一级分类的二级类目
     *
     * @param categoryId
     * @return
     */
    @Override
    public Result queryCategoryTwoByCid(String categoryId) {
        Result result = new Result();
        try {
            List<TbCfGoodstwotypeEntity> categoryTwoList = tbCfGoodstypeDao.queryCategoryTwo(categoryId);
            result.setData(categoryTwoList).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 查询二级分类下的品名
     *
     * @param categoryTwoId
     * @return
     */
    @Override
    public Result queryDescriptionByCTwoId(String categoryTwoId) {
        Result result = new Result();
        try {
            List<TbCfDescripitonEntity> descriptionList = tbCfGoodstypeDao.queryDescription(categoryTwoId);
            result.setData(descriptionList).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 通过品名查询商品
     *
     * @param descriptionId
     * @return
     */
    @Override
    public Result queryItemByDescription(String descriptionId) {
        Result result = new Result();
        try {
            List<TbCfStationItemEntity> itemList = tbCfStationItemDao.queryItemByDescription(descriptionId);
            result.setData(itemList).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 商品收藏
     *
     * @param userId
     * @param itemId
     * @return
     */
    @Override
    public Result itemCollection(String userId, String itemId) {
        Result result = new Result();
        Map map = new HashMap();
        boolean collection = false;
        try {
            TbCfItemCollectionEntity isCollection = tbCfItemCollectionDao.queryIsCollection(userId, itemId);
            if (isCollection != null) {
                collection = true;
                result.setMessage(ResultCodeEnum.SUCCESS.getDesc());
            } else {
                TbCfStationItemEntity item = tbCfStationItemDao.queryObject(itemId);
                if (item != null) {
                    Long count = item.getItemCollectionNum();
                    if (null == count) {
                        count = 0L;
                    }
                    item.setItemCollectionNum(++count);
                    tbCfStationItemDao.update(item);
                }
                TbCfItemCollectionEntity collectionEntity = new TbCfItemCollectionEntity();
                collectionEntity.setId(IdUtil.createIdbyUUID());
                collectionEntity.setUserId(userId);
                collectionEntity.setItemId(itemId);
                collectionEntity.setDelFlag(1);
                collectionEntity.setCreateTime(new Date());
                collectionEntity.setUpdateTime(new Date());
                tbCfItemCollectionDao.save(collectionEntity);
                result.setMessage("Collection of success!");
            }
            map.put("isCollection", collection);
            result.setData(map);
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 用户收藏的商品
     *
     * @param userId
     * @return
     */
    @Override
    public Result queryCollectionByUserId(String userId) {
        Result result = new Result();
        Map<String, Object> map = new HashMap<>();
        try {
            List<TbCfItemCollectionEntity> itemCollectionList = tbCfItemCollectionDao.queryCollectionByUserId(userId);
            List<TbCfItemCollectionEntity> list = new ArrayList<>();
            for (TbCfItemCollectionEntity collection : itemCollectionList) {
                TbCfItemCollectionEntity itemCollectionEntity = new TbCfItemCollectionEntity();
                itemCollectionEntity.setId(collection.getId());
                TbCfStationItemEntity item = tbCfStationItemDao.queryObject(collection.getItemId());
                itemCollectionEntity.setItem(item);
                list.add(itemCollectionEntity);
            }
            map.put("collectionItems", list);
            result.setData(map).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 删除收藏商品
     *
     * @param collectionIds
     * @return
     */
    @Override
    public Result delCollection(String[] collectionIds) {
        Result result = new Result();
        try {
            tbCfItemCollectionDao.deleteBatch(collectionIds);
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage(e.getMessage());
        }
        return result;
    }


}
