package com.diaoyun.zion.chinafrica.service.impl;


import com.diaoyun.zion.chinafrica.constant.KeyConstant;
import com.diaoyun.zion.chinafrica.dao.TbCfItemCommentDao;
import com.diaoyun.zion.chinafrica.entity.TbCfItemCommentEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfItemCommentEntityExtends;
import com.diaoyun.zion.chinafrica.service.TbCfItemCommentService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.common.RedisCache;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.IdUtil;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * Service实现类
 *
 * @author lipengjun
 * @date 2019-11-18 14:31:39
 */
@Service("tbCfItemCommentService")
public class TbCfItemCommentServiceImpl implements TbCfItemCommentService {
    private static Logger logger = LoggerFactory.getLogger(TbCfItemCommentServiceImpl.class);
    @Autowired
    private TbCfItemCommentDao tbCfItemCommentDao;
    @Resource
    private RedisCache<Object> redisCache;

    @Override
    public TbCfItemCommentEntity queryObject(String id) {
        return tbCfItemCommentDao.queryObject(id);
    }

    @Override
    public List<TbCfItemCommentEntity> queryList(Map<String, Object> map) {
        return tbCfItemCommentDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfItemCommentDao.queryTotal(map);
    }

    @Override
    public int save(TbCfItemCommentEntity tbCfItemComment) {
        tbCfItemComment.setId(IdUtil.createIdbyUUID());
        return tbCfItemCommentDao.save(tbCfItemComment);
    }

    @Override
    public int update(TbCfItemCommentEntity tbCfItemComment) {
        return tbCfItemCommentDao.update(tbCfItemComment);
    }

    @Override
    public int delete(String id) {
        return tbCfItemCommentDao.delete(id);
    }

    @Override
    public int deleteBatch(String[] ids) {
        return tbCfItemCommentDao.deleteBatch(ids);
    }

    /**
     * 查询商品最新一条评论
     *
     * @param itemId
     * @return
     */
    @Override
    public Result queryLastComment(String itemId, String userId) {
        Result result = new Result();
        try {
            TbCfItemCommentEntity lastComment = tbCfItemCommentDao.queryLastComment(itemId);
            Map<String, Object> map = new HashMap<>();
            boolean isLike = false;
            if (lastComment != null) {
                double totalScore = lastComment.getItemScore() + lastComment.getLogisticsScore() + lastComment.getPriceScore() + lastComment.getServiceScore();
                BigDecimal total = new BigDecimal(totalScore);
                double score = total.divide(new BigDecimal(4), 1, BigDecimal.ROUND_UP).doubleValue();
                String give_like = (String) redisCache.get(KeyConstant.GIVE_LIKE + userId + itemId + lastComment.getId());
                System.err.println(KeyConstant.GIVE_LIKE + userId + itemId + lastComment.getId());
                System.err.println("===>>>" + give_like);
                lastComment.setLike(false);
                if (!StringUtils.isBlank(give_like) && KeyConstant.YES.equals(give_like)) {
                    lastComment.setLike(true);
                }
                System.err.println("===>>>" + isLike);
                map.put("score", score);
                map.put("lastComment", lastComment);
                result.setData(map).setMessage("success");
                logger.info("query comment success,the itemId is:" + itemId);
            } else {
                result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage("comment is null");
                logger.error("comment is null,the itemId is:" + itemId);
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }

    /**
     * 查询更多评论
     *
     * @param itemId
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    public Result querycomments(String itemId, Integer pageNum, Integer pageSize, String userId) {
        Result<PageInfo> result = new Result();
        try {
            startPage(pageNum, pageSize);
            List<TbCfItemCommentEntity> comments = tbCfItemCommentDao.querycomments(itemId);
            for (TbCfItemCommentEntity comment : comments) {
                comment.setLike(false);
                String give_like = (String) redisCache.get(KeyConstant.GIVE_LIKE + userId + comment.getItemId() + comment.getId());
                System.err.println(KeyConstant.GIVE_LIKE + userId + itemId + comment.getId());
                System.err.println("===>>>" + give_like);
                if (!StringUtils.isBlank(give_like) && KeyConstant.YES.equals(give_like)) {
                    comment.setLike(true);
                }
            }
            PageInfo<TbCfItemCommentEntity> pageInfo = new PageInfo<>(comments);
            result.setData(pageInfo);
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.QUERY_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }

    /**
     * 商品评价
     *
     * @param comment
     * @return
     */
    public Result addComment(TbCfItemCommentEntity comment) {
        Result result = new Result();

        try {
            TbCfItemCommentEntity commentEntity = tbCfItemCommentDao.queryByUser(comment.getItemId(), comment.getUserId());
            if (commentEntity != null) {
                result.setMessage("Already reviewed this product!");
                return result;
            }
            comment.setId(IdUtil.createIdbyUUID());
            comment.setDelFlag(0);
            comment.setLikeNum(0L);
            comment.setCreateTime(new Date());
            comment.setUpdateTime(new Date());
            comment.setType(0);
            if (!StringUtils.isBlank(comment.getUrls())) {
                comment.setType(1);
            }
            int i = tbCfItemCommentDao.save(comment);
            if (i > 0) {
                result.setCode(ResultCodeEnum.SUCCESS.getCode()).setMessage("Comment on success!");
            } else {
                result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage("Comment on failure!");
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }

    /**
     * 删除商品评论
     *
     * @param commentId
     * @return
     */
    @Override
    public Result delComment(String commentId) {
        Result result = new Result();
        try {
            TbCfItemCommentEntity comment = tbCfItemCommentDao.queryObject(commentId);
            comment.setDelFlag(1);
            comment.setUpdateTime(new Date());
            int i = tbCfItemCommentDao.update(comment);
            if (i > 0) {
                result.setCode(ResultCodeEnum.SUCCESS.getCode()).setMessage("Deleted successfully!");
            } else {
                result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage("Deletion failed!");
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }

    /**
     * 点赞
     *
     * @param commentId
     * @param userId
     * @param itemId
     * @return
     */
    @Override
    public Result giveLike(String commentId, String userId, String itemId) {
        Result result = new Result();

        try {
            String give_like = (String) redisCache.get(KeyConstant.GIVE_LIKE + userId + itemId + commentId);
            System.err.println(KeyConstant.GIVE_LIKE + userId + itemId + commentId);
            TbCfItemCommentEntity comment = tbCfItemCommentDao.queryObject(commentId);
            Long likeNum = comment.getLikeNum();
            if (!StringUtils.isBlank(give_like) && KeyConstant.YES.equals(give_like)) {
                comment.setLikeNum(--likeNum);
                redisCache.delete(KeyConstant.GIVE_LIKE + userId + itemId + commentId);
            } else {
                comment.setLikeNum(++likeNum);
                redisCache.set(KeyConstant.GIVE_LIKE + userId + itemId + commentId, KeyConstant.YES);
            }
            tbCfItemCommentDao.update(comment);
            result.setMessage(ResultCodeEnum.SUCCESS.getDesc());
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage());
        }
        return result;
    }


}
