package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfFeedbackDao;
import com.diaoyun.zion.chinafrica.entity.TbCfFeedbackEntity;
import com.diaoyun.zion.chinafrica.service.TbCfFeedbackService;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.base.StateConstant;
import com.diaoyun.zion.master.common.TokenManager;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.security.JwtTokenProvider;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 反馈情况Service实现类
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Service("tbCfFeedbackService")
public class TbCfFeedbackServiceImpl implements TbCfFeedbackService {
    @Autowired
    private TbCfFeedbackDao tbCfFeedbackDao;

    @Autowired
    @Qualifier("redisTokenManager")
    private TokenManager tokenManager;
    @Autowired
    private JwtTokenProvider jwtTokenProvider;

    @Autowired
    private HttpServletRequest request; //自动注入request

    @Override
    public TbCfFeedbackEntity queryObject(String feedbackId) {
        return tbCfFeedbackDao.queryObject(feedbackId);
    }

    @Override
    public List<TbCfFeedbackEntity> queryList(Map<String, Object> map) {
        return tbCfFeedbackDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfFeedbackDao.queryTotal(map);
    }

    @Override
    public int save(TbCfFeedbackEntity tbCfFeedback) {
        tbCfFeedback.setFeedbackId(IdUtil.createIdbyUUID());
        return tbCfFeedbackDao.save(tbCfFeedback);
    }

    @Override
    public int update(TbCfFeedbackEntity tbCfFeedback) {
        return tbCfFeedbackDao.update(tbCfFeedback);
    }

    @Override
    public int delete(String feedbackId) {
        return tbCfFeedbackDao.delete(feedbackId);
    }

    @Override
    public int deleteBatch(String[] feedbackIds) {
        return tbCfFeedbackDao.deleteBatch(feedbackIds);
    }


    @Override
    public Result getFeedbackList() {
        List<TbCfFeedbackEntity> feedbackList=tbCfFeedbackDao.getFeedbackList();
        return new Result<>(feedbackList);
    }
}
