package com.diaoyun.zion.chinafrica.service.impl;


import com.diaoyun.zion.chinafrica.dao.TbCfFeeDao;
import com.diaoyun.zion.chinafrica.entity.TbCfFeeEntity;
import com.diaoyun.zion.chinafrica.service.TbCfFeeService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 手续费Service实现类
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Service("tbCfFeeService")
public class TbCfFeeServiceImpl implements TbCfFeeService {

    @Autowired
    private TbCfFeeDao tbCfFeeDao;

    @Override
    public TbCfFeeEntity queryObject(String feeId) {
        return tbCfFeeDao.queryObject(feeId);
    }

    @Override
    public List<TbCfFeeEntity> queryList(Map<String, Object> map) {
        return tbCfFeeDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfFeeDao.queryTotal(map);
    }

    @Override
    public int save(TbCfFeeEntity tbCfFee) {
        tbCfFee.setFeeId(IdUtil.createIdbyUUID());
        return tbCfFeeDao.save(tbCfFee);
    }

    @Override
    public int update(TbCfFeeEntity tbCfFee) {
        return tbCfFeeDao.update(tbCfFee);
    }

    @Override
    public int delete(String feeId) {
        return tbCfFeeDao.delete(feeId);
    }

    @Override
    public int deleteBatch(String[] feeIds) {
        return tbCfFeeDao.deleteBatch(feeIds);
    }

    @Override
    public TbCfFeeEntity getAvailableFee() {

        return tbCfFeeDao.getAvailableFee();
    }

    @Override
    public TbCfFeeEntity getRateFee() {

        return tbCfFeeDao.getRateFee();
    }
}
