package com.diaoyun.zion.chinafrica.service.impl;


import com.diaoyun.zion.chinafrica.dao.TbCfExchangeDao;
import com.diaoyun.zion.chinafrica.entity.TbCfExchangeEntity;
import com.diaoyun.zion.chinafrica.service.TbCfExchangeService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 汇率管理Service实现类
 *
 * @author lipengjun
 * @date 2019-12-10 11:15:53
 */
@Service("tbCfExchangeService")
public class TbCfExchangeServiceImpl implements TbCfExchangeService {
    @Autowired
    private TbCfExchangeDao tbCfExchangeDao;

    @Override
    public TbCfExchangeEntity queryObject(String id) {
        return tbCfExchangeDao.queryObject(id);
    }

    @Override
    public List<TbCfExchangeEntity> queryList(Map<String, Object> map) {
        return tbCfExchangeDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfExchangeDao.queryTotal(map);
    }

    @Override
    public int save(TbCfExchangeEntity tbCfExchange) {
        tbCfExchange.setId(IdUtil.createIdbyUUID());
        tbCfExchange.setDelFlag(0);
        tbCfExchange.setCreateTime(new Date());
        tbCfExchange.setUpdateTime(new Date());
        return tbCfExchangeDao.save(tbCfExchange);
    }

    @Override
    public int update(TbCfExchangeEntity tbCfExchange) {
        tbCfExchange.setUpdateTime(new Date());
        return tbCfExchangeDao.update(tbCfExchange);
    }

    @Override
    public int delete(String id) {
        return tbCfExchangeDao.delete(id);
    }

    @Override
    public int deleteBatch(String[] ids) {
        return tbCfExchangeDao.deleteBatch(ids);
    }

    @Override
    public void updateByType(String type, BigDecimal rate) {
        tbCfExchangeDao.updateByType(type,rate);
    }

}
