package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfContactDao;
import com.diaoyun.zion.chinafrica.entity.TbCfContactEntity;
import com.diaoyun.zion.chinafrica.service.TbCfContactService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 联系管理Service实现类
 *
 * @author lipengjun
 * @date 2019-09-17 18:03:40
 */
@Service("tbCfContactService")
public class TbCfContactServiceImpl implements TbCfContactService {
    @Autowired
    private TbCfContactDao tbCfContactDao;

    @Override
    public TbCfContactEntity queryObject(String contactId) {
        return tbCfContactDao.queryObject(contactId);
    }

    @Override
    public List<TbCfContactEntity> queryList(Map<String, Object> map) {
        return tbCfContactDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfContactDao.queryTotal(map);
    }

    @Override
    public int save(TbCfContactEntity tbCfContact) {
        tbCfContact.setContactId(IdUtil.createIdbyUUID());
        return tbCfContactDao.save(tbCfContact);
    }

    @Override
    public int update(TbCfContactEntity tbCfContact) {
        return tbCfContactDao.update(tbCfContact);
    }

    @Override
    public int delete(String contactId) {
        return tbCfContactDao.delete(contactId);
    }

    @Override
    public int deleteBatch(String[] contactIds) {
        return tbCfContactDao.deleteBatch(contactIds);
    }

    @Override
    public Result getContactList() {
        List<TbCfContactEntity> contactList=tbCfContactDao.getContactList();
        return new Result<>(contactList);
    }
}
