package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfProblemEntity;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 常见问题Service接口
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
public interface TbCfProblemService {

    /**
     * 根据主键查询实体
     *
     * @param id 主键
     * @return 实体
     */
    TbCfProblemEntity queryObject(String problemId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfProblemEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfProblem 实体
     * @return 保存条数
     */
    int save(TbCfProblemEntity tbCfProblem);

    /**
     * 根据主键更新实体
     *
     * @param tbCfProblem 实体
     * @return 更新条数
     */
    int update(TbCfProblemEntity tbCfProblem);

    /**
     * 根据主键删除
     *
     * @param problemId
     * @return 删除条数
     */
    int delete(String problemId);

    /**
     * 根据主键批量删除
     *
     * @param problemIds
     * @return 删除条数
     */
    int deleteBatch(String[] problemIds);

    /**
     * 获取常见问题
     * @param pageNum
     * @param pageSize
     * @return
     */
    Result getProblemList(Integer pageNum, Integer pageSize);
}
