package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfItemCommentEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfItemCommentEntityExtends;
import com.diaoyun.zion.chinafrica.entity.TbCfReplyEntity;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


import java.util.List;
import java.util.Map;

/**
 * Service接口
 *
 * @author lipengjun
 * @date 2019-11-18 14:31:39
 */
public interface TbCfItemCommentService {

    /**
     * 根据主键查询实体
     *
     * @param id 主键
     * @return 实体
     */
    TbCfItemCommentEntity queryObject(String id);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfItemCommentEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfItemComment 实体
     * @return 保存条数
     */
    int save(TbCfItemCommentEntity tbCfItemComment);

    /**
     * 根据主键更新实体
     *
     * @param tbCfItemComment 实体
     * @return 更新条数
     */
    int update(TbCfItemCommentEntity tbCfItemComment);

    /**
     * 根据主键删除
     *
     * @param id
     * @return 删除条数
     */
    int delete(String id);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return 删除条数
     */
    int deleteBatch(String[] ids);

    Result queryLastComment(String itemId, String userId);

    Result querycomments(String itemId, Integer pageNum, Integer pageSize,String userId);

    Result addComment(TbCfItemCommentEntity comment);

    Result delComment(String commentId);

    Result giveLike(String commentId, String userId, String itemId);


}
