package com.diaoyun.zion.chinafrica.service;


import com.diaoyun.zion.chinafrica.entity.TbCfExchangeEntity;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 汇率管理Service接口
 *
 * @author lipengjun
 * @date 2019-12-10 11:15:53
 */
public interface TbCfExchangeService {

    /**
     * 根据主键查询实体
     *
     * @param id 主键
     * @return 实体
     */
    TbCfExchangeEntity queryObject(String id);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfExchangeEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfExchange 实体
     * @return 保存条数
     */
    int save(TbCfExchangeEntity tbCfExchange);

    /**
     * 根据主键更新实体
     *
     * @param tbCfExchange 实体
     * @return 更新条数
     */
    int update(TbCfExchangeEntity tbCfExchange);

    /**
     * 根据主键删除
     *
     * @param id
     * @return 删除条数
     */
    int delete(String id);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return 删除条数
     */
    int deleteBatch(String[] ids);

    void updateByType(String type, BigDecimal rate);
}
