package com.diaoyun.zion.chinafrica.controller;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.diaoyun.zion.chinafrica.service.TbCfUserInfoService;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.BaseController;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.IdUtil;
import com.diaoyun.zion.master.util.OssUtil;
import com.diaoyun.zion.master.validator.Validator;
import com.diaoyun.zion.master.validator.annotation.ValidateParam;
import freemarker.template.TemplateException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.mail.EmailException;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * 用户相关api
 *
 * @author G
 */
@Api(tags = "用户相关")
@RestController
@RequestMapping("/user")
public class TbCfUserInfoController extends BaseController {

    private static Logger logger = LoggerFactory.getLogger(TbCfUserInfoController.class);

    @Autowired
    private HttpServletRequest request; //自动注入request

    @Autowired
    private TbCfUserInfoService tbCfUserInfoService;
    @Autowired
    private PasswordEncoder passwordEncoder;

    /**
     * 获取邮箱验证码
     */
    @ApiOperation(value = "获取邮箱验证码")
    @GetMapping(value = "/register/identifyCode/{email}/{nick}")
    public Result getUserIdentifyCode(@ApiParam("用户邮箱") @PathVariable("email") @ValidateParam({Validator.NOT_BLANK}) String email,
                                      @ApiParam("用户昵称 url编码") @PathVariable("nick") @ValidateParam({Validator.NOT_BLANK}) String nick) throws EmailException, TemplateException, IOException {
        nick= URLDecoder.decode(nick, Consts.UTF_8.name());
        tbCfUserInfoService.sendRegisterIdentifyCode(email, nick);
        //request.getSession().setAttribute(KeyConstant.IDENTIFY_CODE, identifyCode);
        // TODO 不能返回验证码，先做测试 identifyCode.toString(),
        return new Result("Verification code has been sent");
    }



    /**
     * 获取存在session中的验证码
     */
    /*@ApiOperation(value = "获取存在session中的验证码")
    @GetMapping(value ="/register/identifyCode/old")
    public String getDeliveryList() {
        String identifyCode= (int) request.getSession().getAttribute(KeyConstant.IDENTIFY_CODE);
        return identifyCode;
    }
    */


    @ApiOperation("修改用户信息")
    @PutMapping
    public Result updateUserInfo(@ApiParam ("用户信息")@RequestBody TbCfUserInfoVo tbCfUserInfoVo) {
        int res=tbCfUserInfoService.updateUserInfo(tbCfUserInfoVo);
        return new Result(res, ResultCodeEnum.SUCCESS.getDesc());
    }

    @ApiOperation("修改用户密码")
    @PutMapping(value="/password/{newPassword}/{oldPassword}")
    public Result updatePassWord(@ApiParam("新密码") @PathVariable @ValidateParam({Validator.NOT_BLANK}) String newPassword
            ,@ApiParam("旧密码") @PathVariable @ValidateParam({Validator.NOT_BLANK}) String oldPassword) {
        return tbCfUserInfoService.updatePassWord(newPassword,oldPassword);
    }

    @ApiOperation("重置用户密码 不要带token，否则会验证")
    @PutMapping(value="/password/reset/{account}/{newPassword}/{captcha}")
    public Result resetPassWord(@ApiParam("账号") @PathVariable String account,
                                @ApiParam("新密码") @PathVariable String newPassword,
                                @ApiParam("验证码") @PathVariable  Integer captcha) {
        return tbCfUserInfoService.resetPassWord(account,newPassword,captcha);
    }
    /**
     * 获取用户信息
     */
    @ApiOperation(value = "获取用户信息")
    @GetMapping
    public Result<TbCfUserInfoVo> getUserInfo()  {
        return tbCfUserInfoService.getUserInfo();
    }


    /**
     * 上传头像
     */
    @ApiOperation(value = "上传图片", notes = "上传图片")
    @ApiImplicitParam(paramType = "query", name = "file", value = "图片", required = true, dataType = "MultipartFile")
    @PostMapping("/imageUpload")
    public String imageUpload(@RequestParam("file") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new Exception("上传图片不能为空");
        }
        //上传头像
        String secondaryFolderName="userHeadImage";
        String url = OssUtil.upload(file,secondaryFolderName);
        return url;
    }
}
