package com.diaoyun.zion.chinafrica.controller;

import autovalue.shaded.org.objectweb$.asm.$ClassReader;
import com.diaoyun.zion.chinafrica.entity.TbCfStationItemEntity;
import com.diaoyun.zion.chinafrica.service.TbCfStationItemService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

/**
 * 站点商品Controller
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Api(tags = "商品独立站")
@RestController
@RequestMapping("/itemStation")
public class TbCfStationItemController {
    @Autowired
    private TbCfStationItemService tbCfStationItemService;

    /*
    @ApiOperation("获取商品独立站")
    @GetMapping
    public Result getItemStationList(@ApiParam(value = "页数 默认1") @RequestParam(required = false) Integer pageNum,
                                  @ApiParam(value ="每页大小 默认10") @RequestParam(required = false) Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 2;
        }
        return tbCfStationItemService.getItemStationList(pageNum,pageSize);
    }*/
    @ApiOperation("统计商品点击量")
    @PutMapping("/item/{itemId}")
    public Result updateItemNum(@ApiParam(value = "商品ID") @PathVariable("itemId") String itemId) {
        TbCfStationItemEntity item = tbCfStationItemService.queryObject(itemId);
        if (item != null) {
            Long start = item.getItemNum();
            item.setItemNum(++start);
            int update = tbCfStationItemService.update(item);
            return new Result(update, ResultCodeEnum.SUCCESS.getDesc());
        }
        return new Result(ResultCodeEnum.ERROR.getCode(), ResultCodeEnum.ERROR.getDesc());
    }

    /**
     * 首页商品
     *
     * @return
     */
    @ApiOperation("首页商品")
    @GetMapping("/")
    public Result queryPageHomeItems() {

        return tbCfStationItemService.queryPageHomeItems();
    }


    /**
     * 商品sku
     *
     * @param itemId
     * @return
     */
    @ApiOperation("商品sku")
    @GetMapping("/queryItemSku")
    public Result queryItemSku(@ApiParam(value = "商品ID") @RequestParam(value = "itemId") String itemId,
                               @ApiParam(value = "用户ID") @RequestParam(value = "userId", required = false) String userId) {

        return tbCfStationItemService.queryItemSku(itemId, userId);
    }

    /**
     * 商品搜索
     *
     * @param name
     * @return
     */
    @ApiOperation("商品搜索")
    @GetMapping("/searchItems")
    public Result searchItems(@ApiParam(value = "名字") @RequestParam(value = "name") String name,
                              @ApiParam(value = "排序") @RequestParam(value = "order", required = false) String order) {

        return tbCfStationItemService.searchItems(name, order);
    }

    /**
     * 查询一级分类的二级类目
     *
     * @param categoryId
     * @return
     */
    @ApiOperation("查询一级分类的二级类目")
    @GetMapping("/queryCategoryTwoByCid/{categoryId}")
    public Result queryCategoryTwoByCid(@ApiParam(value = "一级分类ID") @PathVariable("categoryId") String categoryId) {

        return tbCfStationItemService.queryCategoryTwoByCid(categoryId);
    }

    /**
     * 查询二级分类下的品名
     *
     * @param categoryTwoId
     * @return
     */
    @ApiOperation("查询二级分类下的品名")
    @GetMapping("/queryDescriptionByCTwoId/{categoryTwoId}")
    public Result queryDescriptionByCTwoId(@ApiParam(value = "二级分类ID") @PathVariable("categoryTwoId") String categoryTwoId) {

        return tbCfStationItemService.queryDescriptionByCTwoId(categoryTwoId);
    }

    /**
     * 通过品名查询商品
     *
     * @param descriptionId
     * @return
     */
    @ApiOperation("通过品名查询商品")
    @GetMapping("/queryItemByDescription/{descriptionId}")
    public Result queryItemByDescription(@ApiParam(value = "二级分类ID") @PathVariable("descriptionId") String descriptionId) {

        return tbCfStationItemService.queryItemByDescription(descriptionId);
    }


    /**
     * 商品收藏
     *
     * @param userId
     * @param itemId
     * @return
     */
    @ApiOperation("商品收藏")
    @PutMapping("/itemCollection/{userId}/{itemId}")
    public Result itemCollection(@ApiParam(value = "用户ID") @PathVariable("userId") String userId,
                                 @ApiParam(value = "商品ID") @PathVariable("itemId") String itemId) {
        return tbCfStationItemService.itemCollection(userId, itemId);
    }

    /**
     * 用户的收藏商品
     *
     * @param userId
     * @return
     */
    @ApiOperation("用户的收藏商品")
    @GetMapping("/queryCollectionByUserId/{userId}")
    public Result queryCollectionByUserId(@ApiParam(value = "用户ID") @PathVariable("userId") String userId) {

        return tbCfStationItemService.queryCollectionByUserId(userId);
    }

    /**
     * 删除收藏商品
     *
     * @param collectionIds
     * @return
     */
    @ApiOperation("删除收藏商品")
    @DeleteMapping("/delCollection")
    public Result delCollection(@ApiParam(value = "收藏商品ID") @RequestBody String[] collectionIds) {

        return tbCfStationItemService.delCollection(collectionIds);
    }


}
