package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.entity.UserInfo;
import com.diaoyun.zion.chinafrica.service.TbCfUserInfoService;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.BaseController;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;

/**
 * 用户登录
 *
 * @author G
 */
@Api(tags = "用户登录")
@RestController
@RequestMapping("/login")
public class LoginController extends BaseController {

    private static Logger logger = LoggerFactory.getLogger(LoginController.class);

    @Autowired
    private HttpServletRequest request; //自动注入request

    @Autowired
    private TbCfUserInfoService tbCfUserInfoService;

    @ApiOperation(value = "注册并登录")
    @PostMapping(value = "/register")
    public Result<TbCfUserInfoVo> registerAndLogin(@ApiParam("用户信息") @RequestBody TbCfUserInfoVo tbCfUserInfoVo) throws ParseException {
        return tbCfUserInfoService.registerAndLogin(tbCfUserInfoVo);
    }

    @ApiOperation(value = "注册并登录")
    @PostMapping(value = "/registerByPhone")
    public Result<TbCfUserInfoVo> registerByPhone(@ApiParam("用户信息") @RequestBody TbCfUserInfoVo tbCfUserInfoVo, @ApiParam(value = "验证码") @RequestParam("code") String code) throws ParseException {
        return tbCfUserInfoService.registerByPhone(tbCfUserInfoVo, code);
    }

    @ApiOperation("登录")
    @PostMapping
    public Result<TbCfUserInfoVo> login(@ApiParam(value = "登录名") String account,
                                        @ApiParam(value = "密码") String password) {
        return tbCfUserInfoService.login(getIpAddr(request), account, password);
    }

    @ApiOperation("使用token登录")
    @GetMapping("/token")
    public Result<TbCfUserInfoVo> loginByToken() {
        return tbCfUserInfoService.loginByToken(getIpAddr(request));
    }

    @ApiOperation("使用手机号登录")
    @GetMapping("/phone")
    public Result<TbCfUserInfoVo> loginByPhone(@ApiParam(value = "手机号") @RequestParam("phone") String phone,
                                               @ApiParam(value = "验证码") @RequestParam("code") String code) {
        return tbCfUserInfoService.loginByPhone(getIpAddr(request), phone, code);
    }

    /**
     * 获取短信验证码
     */
    @ApiOperation(value = "获取短信验证码")
    @GetMapping(value = "/register/identifyCode/{phone}")
    public Result getUserPhoneCode(@ApiParam("手机号") @PathVariable("phone") String phone) throws IOException {
        tbCfUserInfoService.getUserPhoneCode(phone);
        return new Result("Verification code has been sent");
    }

    @ApiOperation("第三方登录")
    @PostMapping("/thirdParty")
    // TODO
    @Deprecated
    public Result<TbCfUserInfoVo> loginByThirdParty(@ApiParam("第三方账号") @RequestParam(required = false) String amount,
                                                    @ApiParam("用户昵称 url编码") @RequestParam(required = false) String nick,
                                                    @ApiParam("账号类型") @RequestParam(required = false) String userType) throws UnsupportedEncodingException {
        return tbCfUserInfoService.loginByThirdParty(getIpAddr(request), amount, nick, userType);
    }

    @ApiOperation(value = "校验账户和昵称")
    @GetMapping("/checkAccount")
    public Result checkUserByNick(@ApiParam("用户昵称 url编码") @RequestParam("name") String name) {
        Result result = new Result();
        boolean b = tbCfUserInfoService.checkUserByNick(name);
        UserInfo userInfo = new UserInfo();
        userInfo.setAvailable(b);
        if (!b) {
            result.setCode(ResultCodeEnum.VALIDATE_ERROR.getCode()).setMessage("Do not use!");
        } else {
            result.setCode(ResultCodeEnum.SUCCESS.getCode()).setMessage("available!");
        }
        result.setData(userInfo);
        return result;
    }

    @ApiOperation("验证手机号")
    @GetMapping("/checkByPhone/{phone}")
    public Result checkByPhone(@ApiParam("手机号") @PathVariable("phone") String phone) {
        return tbCfUserInfoService.checkByPhone(phone);
    }

}
