package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.entity.TbCfGoodstypeEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfStationItemEntity;
import com.diaoyun.zion.chinafrica.service.TbCfGoodstypeService;
import com.diaoyun.zion.chinafrica.service.TbCfStationItemService;
import com.diaoyun.zion.chinafrica.vo.StationToGoodsType;
import com.diaoyun.zion.master.base.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/goodsType")
public class GoodsTypeController {
    private static Logger logger = LoggerFactory.getLogger(LoginController.class);

    @Autowired
    private HttpServletRequest request; //自动注入request

    @Autowired
    private TbCfGoodstypeService tbCfGoodstypeService;

    @Autowired
    private TbCfStationItemService tbCfStationItemService;

    @RequestMapping("/getGoodsTypeList")
    @GetMapping
    public Map<String,List<StationToGoodsType>> getGoodsTypeList() {
        Map<String,List<StationToGoodsType>> map = new HashMap<>();
        List<StationToGoodsType> listStation = new ArrayList<StationToGoodsType>();
        List<TbCfGoodstypeEntity> list = tbCfGoodstypeService.queryList(null);
        for (TbCfGoodstypeEntity goods:list) {
            StationToGoodsType goodsType = new StationToGoodsType();
            goodsType.setCategoryId(goods.getGoodstypeId());
            goodsType.setGoodstypetitle(goods.getGoodstypeTitle());
            goodsType.setGoodstypeUrl(goods.getGoodstypeUrl());
            List<TbCfStationItemEntity> station =  tbCfStationItemService.getGoodsTypeList(goods.getGoodstypeId());
            goodsType.setStationlist(station);
            listStation.add(goodsType);
        }
        map.put("data",listStation);
        return map;
    }

    @RequestMapping("/getItemStationList")
    @GetMapping
    public Result getItemStationList(@RequestParam(required = false) Integer pageNum,
                                      @RequestParam(required = false) Integer pageSize,
                                     @RequestParam(required = false) String categoryId) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 6;
        }
        return tbCfStationItemService.getItemStationList(pageNum,pageSize,categoryId);
    }
}
