package com.diaoyun.zion.chinafrica.client;

import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.common.TokenManager;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.security.JwtTokenProvider;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * 验证请求用户是否已经登录
 *
 * @author G
 */
@Configuration
@Aspect
public class TokenVerification {
    @Autowired
    private HttpServletRequest request;
    @Resource(name = "redisTokenManager")
    private TokenManager tokenManager;
    @Autowired
    private JwtTokenProvider jwtTokenProvider;

    //验证是否登录
    //@Pointcut("!execution(* com.diaoyun.zion.chinafrica.controller.LoginController*.*(..))&&within(com.diaoyun.zion.chinafrica.controller.*)")
    @Pointcut("within(com.diaoyun.zion.chinafrica.controller.*)" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.SpiderController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfPlatformController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfStationItemController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.LoginController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfProblemController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfContactController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfStoreController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfHomePageController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfUserInfoController.resetPassWord(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfFeedbackController.getFeedbackList(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfUserInfoController.getUserIdentifyCode(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.GoodsTypeController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.VersionController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.TbCfFeeController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.PayPalController.*(..))" +
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.ShopifyController.*(..))"+
            "&&!execution(* com.diaoyun.zion.chinafrica.controller.FlutterWaveController.*(..))"
    )
    public void controllerAspect() {

    }

    //通知：在所拦截方法的前后执行一段逻辑
    @Around("controllerAspect()")
    public Object validateLogin(ProceedingJoinPoint pjp) throws Throwable {
        Result result;
        //获取用户
        String token = jwtTokenProvider.resolveToken(request);
        //不需要登录
        if (StringUtils.isNotBlank(token) && tokenManager.validate(token) != null) {
            return pjp.proceed();
        } else {
            result = new Result().setCode(ResultCodeEnum.NEED_LOGIN.getCode()).setMessage(ResultCodeEnum.NEED_LOGIN.getDesc());
        }
        return result;
    }
}
