package com.diaoyun.zion.chinafrica.api;

import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.OssUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;
import java.util.Map;

/**
 * @Auther: wudepeng
 * @Date: 2020/01/09
 * @Description:文件上传API
 */
@Api(tags = "文件上传API")
@RestController
@RequestMapping("/api/upload")
public class UploadController {

    @ApiOperation("文件上传")
    @PostMapping("/uploadFile")
    public Result uploadFile(@RequestParam("file") MultipartFile file) throws Exception {
        Result result = new Result();
        Map map = new HashMap();
        String url = OssUtil.upload(file, "Afrishop");
        map.put("url", url);
        result.setData(map).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        return result;
    }

    @ApiOperation("删除文件")
    @DeleteMapping("/delFile")
    public Result delFile(@RequestParam("url") String url) {
        Result result = new Result();
        Map map = new HashMap();
        boolean b = OssUtil.deleteFile(url);
        map.put("isDeleted", b);
        result.setData(map).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        return result;
    }
}
