/*
 * Decompiled with CFR 0.152.
 */
package com.github.theresasogunle;

import com.github.theresasogunle.ApiQuery;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;

public class ApiConnection {
    private final String url;

    public ApiConnection(String url) {
        this.url = url;
        this.enforceTlsV1point2();
    }

    private void enforceTlsV1point2() {
        try {
            SSLContext sslContext = SSLContexts.custom().useTLS().build();
            SSLConnectionSocketFactory f = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(f).build();
            Unirest.setHttpClient(httpClient);
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            Logger.getLogger(ApiConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public JSONObject connectAndQuery(ApiQuery query) {
        try {
            HttpResponse<JsonNode> queryForResponse = Unirest.post(this.url).header("Accept", "application/json").fields(query.getParams()).asJson();
            try {
                return queryForResponse.getBody().getObject();
            }
            catch (Exception exception) {
            }
        }
        catch (UnirestException unirestException) {
            // empty catch block
        }
        return null;
    }

    public JSONObject connectAndQuery(HashMap<String, Object> query) {
        try {
            HttpResponse<JsonNode> queryForResponse = Unirest.post(this.url).header("Accept", "application/json").fields(query).asJson();
            return queryForResponse.getBody().getObject();
        }
        catch (UnirestException unirestException) {
            return null;
        }
    }

    public JsonNode connectAndQueryWithGet() {
        try {
            HttpResponse<JsonNode> queryForResponse = Unirest.get(this.url).header("content-type", "application/json").asJson();
            return queryForResponse.getBody();
        }
        catch (UnirestException e) {
            System.out.println("Cant query at this time!");
            return null;
        }
    }
}

