package com.diaoyun.zion.master.util;

import net.sf.json.JSONObject;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsoupUtil {
    public static String unknow = "未知";
    private static Logger logger = LoggerFactory.getLogger(JsoupUtil.class);
    /**
     * 获取淘宝商品详情的信息 店铺id 名字 主图 sibUrl 等
     *
     * @param content
     * @return
     */
    public static Map<String, String> getTbItemDetail(String content) {
        String variableName = "g_config";
        String configGroup = getScriptContent(content, variableName);
        Map<String, String> returnMap = new HashMap<>();
        String varArr[] = configGroup.split(";");
        for (String variable : varArr) {
            //获取g_config 变量
            Pattern variablePattern = Pattern.compile("(var){1,1}\\s+(g_config){1,1}\\s+={1,1}[\\s\\S]*"); //  Regex for the value of the key
            Matcher varMatcher = variablePattern.matcher(variable);
            while (varMatcher.find()) {
                String configStr = varMatcher.group();
                //获取 sibUrl itemId shopId shopName 获取item里面的数据，包括title pic（主图地址） 这些值都是字符串
                List<String> needInfo = new ArrayList<>();
                needInfo.add("sibUrl");
                needInfo.add("itemId");
                needInfo.add("shopId");
                needInfo.add("shopName");
                needInfo.add("url");
                needInfo.add("pic");
                needInfo.add("title");
                //从返回的字符串中获取变量的值
                getInfoFromJsStr(needInfo, configStr, returnMap);
            }
        }

        /*//加入店铺链接
        if(returnMap.get("shopId")!=null) {
            String shopAddress="https://shop"+returnMap.get("shopId")+".taobao.com/";
            returnMap.put("title",shopAddress);
        }*/
        //unicode 解码
        if (returnMap.get("shopName") != null) {
            //unicode 解码
            String convertStr = StringEscapeUtils.unescapeJava(returnMap.get("shopName"));
            returnMap.put("shopName", convertStr);
        }
        if (returnMap.get("title") != null) {
            //unicode 解码
            String convertStr = StringEscapeUtils.unescapeJava(returnMap.get("title"));
            returnMap.put("title", convertStr);
        }
        return returnMap;
    }

    /**
     * 根据script中的变量名获取script中变量相关的内容
     *
     * @param content
     * @param variableName
     * @return
     */
    private static String getScriptContent(String content, String variableName) {
        //logger.info(content);
        Document document = Jsoup.parse(content);
        Elements elementList = document.getElementsByTag("script");
        String configGroup = null;
        for (Element element : elementList) {
            for (DataNode dataNode : element.dataNodes()) {
                String dataStr = dataNode.getWholeData();
                //获取带有 g_config 变量的 script 标签
                Pattern p = Pattern.compile("(var){1,1}\\s+(" + variableName + "){1,1}\\s+={1,1}[\\s\\S]*(;){1,1}"); //  Regex for the value of the key
                Matcher m = p.matcher(dataStr); // you have to use html here and NOT text! Text will drop the 'key' part
                while ((m.find())) {
                    //System.out.println(m.group());
                    configGroup = m.group();

                }
            }
        }
        return configGroup;
    }
    /**
     * 根据script中的变量名获取script中变量相关的内容，特指天猫的返回信息 没什么用，没有商品的规格信息
     *
     * @param content
     * @return
     */
    @Deprecated
    private static String getTmScriptContent(String content) {
        //logger.info(content);
        Document document = Jsoup.parse(content);
        Elements elementList = document.getElementsByTag("script");
        String configGroup = null;
        for (Element element : elementList) {
            for (DataNode dataNode : element.dataNodes()) {
                String dataStr = dataNode.getWholeData();
                //获取带有 g_config 变量的 script 标签
                Pattern p = Pattern.compile("(TShop.Setup){1,1}[\\s\\S]*?(\\);){1,1}"); //  Regex for the value of the key
                Matcher m = p.matcher(dataStr); // you have to use html here and NOT text! Text will drop the 'key' part
                while ((m.find())) {
                    //System.out.println(m.group());
                    configGroup = m.group();
                    int firstBrackets=configGroup.indexOf("{");
                    int lastbrackets=configGroup.lastIndexOf("}");
                    configGroup=configGroup.substring(firstBrackets,lastbrackets+1);
                }
            }
        }
        return configGroup;
    }

    private static void getInfoFromJsStr(List<String> needInfo, String configStr, Map<String, String> returnMap) {
        for (String info : needInfo) {
            //获取 相关信息
            String patternStr = "((" + info + "){1,1}?)\\s+(:{1,1}?)[\\s]*(('){1,1}?)[\\S]*(('){1,1}?)";
            Pattern infoPattern = Pattern.compile(patternStr); //  Regex for the value of the key
            Matcher infoMatcher = infoPattern.matcher(configStr);
            while (infoMatcher.find()) {
                int infoBegin = infoMatcher.group().indexOf("'");
                int infoEnd = infoMatcher.group().lastIndexOf("'");
                String infoValue = infoMatcher.group().substring(infoBegin + 1, infoEnd);
                //获取 infoValue
                returnMap.put(info, infoValue);
            }
        }
    }

    /**
     * 解析出商品详情
     *
     * @param content
     * @return
     */
    public static Map<String, Object> getPropMap(String content) {
        Map<String, Object> resultMap = new HashMap<>();
        Document document = Jsoup.parse(content);
        Element skuElement = document.getElementById("J_isku");
        Elements propList = skuElement.getElementsByClass("J_Prop");
        if (propList == null || propList.size() < 1) {
            resultMap.put("hasSku", false);
        } else {
            getSku(propList, resultMap);
        }
        return resultMap;
    }

    /**
     * 获取sku 对照着返回html来写方法
     *
     * @param propList
     * @param resultMap
     */
    private static void getSku(Elements propList, Map<String, Object> resultMap) {
        for (Element element : propList) {
            //属性描述
            Elements propNameELements = element.getElementsByClass("tb-property-type");
            String propName = JsoupUtil.unknow;
            if (propNameELements != null && propNameELements.size() > 0) {
                propName = propNameELements.get(0).text();
            }

            if (resultMap.get(propName) == null) {
                //防止属性名重复
            } else {
                int random = (int) (Math.random() * 1000);
                propName = propName + random;
            }
            Map<String, Object> skuMap = new HashMap<>();
            resultMap.put(propName, skuMap);

            Elements liList = element.getElementsByTag("li");
            if (liList != null && liList.size() > 0) {
                for (Element liEle : liList) {
                    String propKey = liEle.attr("data-value");
                    Elements spanList = liEle.getElementsByTag("span");
                    Elements aList = liEle.getElementsByTag("a");
                    String title = JsoupUtil.unknow;
                    String image = "";
                    if (liList != null && liList.size() > 0) {
                        title = spanList.get(0).text();
                    }
                    if (liList != null && liList.size() > 0) {
                        image = aList.get(0).attr("style");
                    }
                    Map<String, Object> propMap = new HashMap<>();
                    propMap.put("title", title);
                    propMap.put("image", image);
                    ((Map<String, Object>) resultMap.get(propName)).put(propKey, propMap);
                }
            }
        }
    }

    /**
     * 获取天猫商品详情 手机端的，手机端在香港会返回与大陆不一样的页面信息
     *
     * @param content
     * @return
     */
    public static JSONObject getTmItemDetail(String content) {
        String variableName = "_DATA_Detail";
        String detailStr = getScriptContent(content, variableName);
        //Map<String, String> returnMap = new HashMap<>();

        int firstBrackets=detailStr.indexOf("{");
        int lastbrackets=detailStr.lastIndexOf("}");
        detailStr=detailStr.substring(firstBrackets,lastbrackets+1);
        JSONObject dataMap= JSONObject.fromObject(detailStr);
        return dataMap;
    }
    /**
     * 获取天猫商品详情
     *
     * @param content
     * @return
     */
   /* public static JSONObject getTmItemDetail(String content) {
        //String variableName = "TShop.Setup";
        String detailStr = getTmScriptContent(content);
        JSONObject dataMap= JSONObject.fromObject(detailStr);
        return dataMap;
    }*/
}

