package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfTaxDao;
import com.diaoyun.zion.chinafrica.entity.TbCfTaxEntity;
import com.diaoyun.zion.chinafrica.service.TbCfTaxService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 税费管理Service实现类
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Service("tbCfTaxService")
public class TbCfTaxServiceImpl implements TbCfTaxService {
    @Autowired
    private TbCfTaxDao tbCfTaxDao;

    @Override
    public TbCfTaxEntity queryObject(String taxId) {
        return tbCfTaxDao.queryObject(taxId);
    }

    @Override
    public List<TbCfTaxEntity> queryList(Map<String, Object> map) {
        return tbCfTaxDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfTaxDao.queryTotal(map);
    }

    @Override
    public int save(TbCfTaxEntity tbCfTax) {
        tbCfTax.setTaxId(IdUtil.createIdbyUUID());
        return tbCfTaxDao.save(tbCfTax);
    }

    @Override
    public int update(TbCfTaxEntity tbCfTax) {
        return tbCfTaxDao.update(tbCfTax);
    }

    @Override
    public int delete(String taxId) {
        return tbCfTaxDao.delete(taxId);
    }

    @Override
    public int deleteBatch(String[] taxIds) {
        return tbCfTaxDao.deleteBatch(taxIds);
    }
}
