package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfProblemDao;
import com.diaoyun.zion.chinafrica.entity.TbCfProblemEntity;
import com.diaoyun.zion.chinafrica.service.TbCfProblemService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.util.IdUtil;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * 常见问题Service实现类
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Service("tbCfProblemService")
public class TbCfProblemServiceImpl implements TbCfProblemService {
    @Autowired
    private TbCfProblemDao tbCfProblemDao;

    @Override
    public TbCfProblemEntity queryObject(String problemId) {
        return tbCfProblemDao.queryObject(problemId);
    }

    @Override
    public List<TbCfProblemEntity> queryList(Map<String, Object> map) {
        return tbCfProblemDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfProblemDao.queryTotal(map);
    }

    @Override
    public int save(TbCfProblemEntity tbCfProblem) {
        tbCfProblem.setProblemId(IdUtil.createIdbyUUID());
        return tbCfProblemDao.save(tbCfProblem);
    }

    @Override
    public int update(TbCfProblemEntity tbCfProblem) {
        return tbCfProblemDao.update(tbCfProblem);
    }

    @Override
    public int delete(String problemId) {
        return tbCfProblemDao.delete(problemId);
    }

    @Override
    public int deleteBatch(String[] problemIds) {
        return tbCfProblemDao.deleteBatch(problemIds);
    }

    @Override
    public Result getProblemList(Integer pageNum, Integer pageSize) {
        Result<PageInfo> result = new Result<>();
        startPage(pageNum,pageSize);
        List<TbCfProblemEntity> problemList=tbCfProblemDao.getProblemList();
        PageInfo<TbCfProblemEntity> pageInfo = new PageInfo<>(problemList);
        result.setData(pageInfo);
        return result;
    }
}
