package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfFeeEntity;

import java.util.List;
import java.util.Map;

/**
 * 手续费Service接口
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
public interface TbCfFeeService {

    /**
     * 根据主键查询实体
     *
     * @param feeId 主键
     * @return 实体
     */
    TbCfFeeEntity queryObject(String feeId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfFeeEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfFee 实体
     * @return 保存条数
     */
    int save(TbCfFeeEntity tbCfFee);

    /**
     * 根据主键更新实体
     *
     * @param tbCfFee 实体
     * @return 更新条数
     */
    int update(TbCfFeeEntity tbCfFee);

    /**
     * 根据主键删除
     *
     * @param feeId
     * @return 删除条数
     */
    int delete(String feeId);

    /**
     * 根据主键批量删除
     *
     * @param feeIds
     * @return 删除条数
     */
    int deleteBatch(String[] feeIds);

    /**
     * 获取当前生效的手续费设置
     * @return
     */
    TbCfFeeEntity getAvailableFee();
}
