package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfCouponUseEntity;

import java.util.List;
import java.util.Map;

/**
 * 使用优惠券记录Service接口
 *
 * @author G
 * @date 2019-08-14 09:11:47
 */
public interface TbCfCouponUseService {

    /**
     * 根据主键查询实体
     *
     * @param useId 主键
     * @return 实体
     */
    TbCfCouponUseEntity queryObject(String useId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfCouponUseEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfCouponUse 实体
     * @return 保存条数
     */
    int save(TbCfCouponUseEntity tbCfCouponUse);

    /**
     * 根据主键更新实体
     *
     * @param tbCfCouponUse 实体
     * @return 更新条数
     */
    int update(TbCfCouponUseEntity tbCfCouponUse);

    /**
     * 根据主键删除
     *
     * @param useId
     * @return 删除条数
     */
    int delete(String useId);

    /**
     * 根据主键批量删除
     *
     * @param useIds
     * @return 删除条数
     */
    int deleteBatch(String[] useIds);
}
