package com.diaoyun.zion.chinafrica.enums;


import com.diaoyun.zion.master.enums.EnumItemable;

/**
 * 订单状态
 * 
 * @author G
 */
public enum OrderStatusEnum implements EnumItemable<OrderStatusEnum> {

	CANCEL("取消", 0),
	PENDING_PAY("等待付款", 10),
	PAID("已付款", 20),
	SHIPPED("已发货", 40),
	SUCCESS("交易成功", 50),
	CLOSE("交易关闭", 60);

	private String label;
	private Integer value;


	OrderStatusEnum(String label, Integer value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return this.label;
	}

	public Integer getValue() {
		return this.value;
	}
}
