package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.entity.TbCfCategoryHsEntity;
import com.diaoyun.zion.chinafrica.service.TbCfCategoryHsService;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/**
 * 商品报关品名表（从第三方合作商拿过来的）Controller
 *
 * @author lipengjun
 * @date 2019-08-30 09:54:02
 */
@Api(tags = "报关类型")
@RestController
@RequestMapping("categoryhs")
public class TbCfCategoryHsController {
    @Autowired
    private TbCfCategoryHsService tbCfCategoryHsService;

    /**
     * 查看所有列表
     */
    @ApiOperation("查看所有列表")
    @RequestMapping("/queryAll")
    public Result<List<TbCfCategoryHsEntity>> queryAll() {
        List<TbCfCategoryHsEntity> list = tbCfCategoryHsService.queryList(null);
        return new Result<>(list);
    }



}
